package com.mmc.csf.release.controller;

import com.mmc.csf.common.util.web.ResultBody;
import com.mmc.csf.release.forum.dto.DynamicInfoDTO;
import com.mmc.csf.release.forum.qo.DynamicQO;
import com.mmc.csf.release.service.BackstageForumService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import javax.servlet.http.HttpServletRequest;

/**
 * @Author LW
 *
 * @date 2023/6/19 10:44 概要：
 */
@Api(tags = {"后台-论坛管理-模块"})
@RestController
@RequestMapping("/backstage/forum")
public class BackstageForumController {

  @Autowired BackstageForumService backstageForumService;

  @ApiOperation(value = "后台-动态列表")
  @PostMapping("/listDynamic")
  @ApiResponses({@ApiResponse(code = 200, message = "OK", response = DynamicInfoDTO.class)})
  public ResultBody<DynamicInfoDTO> listDynamic(
      @RequestBody DynamicQO dynamic, HttpServletRequest request) {
    return ResultBody.success(backstageForumService.listDynamic(dynamic, request));
  }

  @ApiOperation(value = "动态删除")
  @PostMapping("/deleteDynamic")
  @ApiResponses({@ApiResponse(code = 200, message = "OK", response = ResultBody.class)})
  public ResultBody deleteDynamic(@RequestParam Integer dynamicId) {
    return backstageForumService.deleteDynamic(dynamicId);
  }

  @ApiOperation(value = "动态隐藏")
  @PostMapping("/hiddenDynamic")
  @ApiResponses({@ApiResponse(code = 200, message = "OK", response = ResultBody.class)})
  public ResultBody hiddenDynamic(@RequestParam Integer dynamicId) {
    return backstageForumService.hiddenDynamic(dynamicId);
  }
}
