package com.mmc.csf.release.entity.store;

import com.mmc.csf.web.dto.DummyUavDTO;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.io.Serializable;
import java.math.BigDecimal;

/**
 * Author: geDuo
 * Date: 2022/5/27 17:52
 */
@Data
@Builder
@NoArgsConstructor
@AllArgsConstructor
public class DummyUavDO implements Serializable {
    private Integer id;
    private String uavName;
    private String code;
    private Integer online;
    private Double lon;
    private Double lat;
    private Double distance;

    public DummyUavDO(DummyUavDTO d) {
        this.uavName = d.getUavName();
        this.code = d.getID();
        this.online = d.getOnline();
        this.lon = d.getLon();
        this.lat = d.getLat();
    }

    public DummyUavDTO buildDummyUavDTO() {
        this.distance = this.distance == null ? 0 : (BigDecimal.valueOf(this.distance).setScale(2, BigDecimal.ROUND_HALF_DOWN)).doubleValue();
        return DummyUavDTO.builder().uavName(this.uavName).ID(this.code).online(this.online).lon(this.lon).lat(this.lat).distance(this.distance / 1000).build();
    }
}
