package com.mmc.csf.release.forum.vo;

import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.io.Serializable;
import java.util.List;

/**
 * @Author LW
 * @date 2023/5/15 10:29
 * 概要：评论信息参数
 */
@Data
@NoArgsConstructor
@AllArgsConstructor
@Builder
public class CommentAndReplyVO implements Serializable {
    @ApiModelProperty(value = "评论id")
    private Integer id;
    @ApiModelProperty(value = "动态id")
    private Integer dynamicId;
    @ApiModelProperty(value = "父级评论id")
    private Integer parentId;
    @ApiModelProperty(value = "模拟用户id")
    private Integer userId;
    @ApiModelProperty(value = "评论内容")
    private String content;
    @ApiModelProperty(value = "评论点赞数")
    private Integer likesCount;
    private List<CommentAndReplyVO> children;
}
