package com.mmc.csf.release.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.mmc.csf.common.util.json.JsonUtil;
import com.mmc.csf.common.util.page.PageResult;
import com.mmc.csf.common.util.web.ResultBody;
import com.mmc.csf.common.util.web.ResultEnum;
import com.mmc.csf.infomation.dto.*;
import com.mmc.csf.infomation.qo.IndustryCaseQO;
import com.mmc.csf.infomation.vo.*;
import com.mmc.csf.release.dao.RequirementsDao;
import com.mmc.csf.release.entity.requirements.*;
import com.mmc.csf.release.feign.PmsAppApi;
import com.mmc.csf.release.feign.UserAppApi;
import com.mmc.csf.release.industry.IndustryTypeDTO;
import com.mmc.csf.release.service.RequirementsService;
import com.mmc.csf.release.util.RestTemplateUtil;
import lombok.extern.slf4j.Slf4j;
import org.gavaghan.geodesy.Ellipsoid;
import org.gavaghan.geodesy.GeodeticCalculator;
import org.gavaghan.geodesy.GeodeticCurve;
import org.gavaghan.geodesy.GlobalCoordinates;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.data.redis.core.StringRedisTemplate;
import org.springframework.http.*;
import org.springframework.stereotype.Service;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.RestClientException;
import org.springframework.web.client.RestTemplate;

import javax.servlet.http.HttpServletRequest;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.*;
import java.util.stream.Collectors;

/**
 * @author: zj
 * @Date: 2023/5/18 14:29
 */
@Slf4j
@Service
public class RequirementsServiceImpl implements RequirementsService {
    @Autowired
    private RequirementsDao requirementsDao;

    @Autowired
    private UserAppApi userAppApi;

    @Autowired
    private RestTemplateUtil restTemplateUtil;

    @Autowired
    private RestTemplate restTemplate;

    @Value("${iuav.omsapp.url}")
    private String omsApp;

    @Autowired
    private PmsAppApi pmsAppApi;

    @Value("${iuav.userapp.url}")
    private String userApp;

    @Value("${iuav.pmsapp.url}")
    private String pmsApp;

    @Autowired
    private StringRedisTemplate stringRedisTemplate;

    @Override
    public ResultBody listType(Integer id) {
        List<RequirementsTypeDO> requirementsTypeDOList = requirementsDao.listTypeReq(id);
        List<RequirementsTypeVO> requirementsTypeVOList = requirementsTypeDOList.stream().map(RequirementsTypeDO::buildRequirementsTypeVO).collect(Collectors.toList());
        return ResultBody.success(requirementsTypeVOList);
    }

    @Override
    public ResultBody publish(RequirementsInfoVO requirementsInfoVO, HttpServletRequest request) {
        //是否完成认证
//        UserAccountSimpleDTO userAccountSimpleDTO = userAppApi.feignGetUserSimpleInfo(requirementsInfoVO.getUserAccountId());
//        if (userAccountSimpleDTO == null || !userAccountSimpleDTO.getCompanyAuthStatus().toString().equals("1")){
//            return ResultBody.error(ResultEnum.COMPANY_NOT_VERIFY_ERROR);
//        }

        RequirementsInfoDO requirementsInfoDO = new RequirementsInfoDO(requirementsInfoVO);
        requirementsInfoDO.setPublisherNumber(randomOrderCode());
        requirementsDao.addRequirementsInfo(requirementsInfoDO);
        return ResultBody.success();
    }

    HttpHeaders headers = new HttpHeaders();


    @Override
    public ResultBody solveRequire(Integer requirementsInfoId, Integer userAccountId) {
        RequirementsInfoDO requirementsInfoDO = requirementsDao.getRequirementsInfoById(requirementsInfoId);
        if (!requirementsInfoDO.getUserAccountId().toString().equals(userAccountId.toString())) {
            return ResultBody.error("无权限");
        }
        requirementsDao.solveRequire(requirementsInfoId);
        return ResultBody.success();
    }

    @Override
    public ResultBody listPublishPage(IndustryCaseQO industryCaseQO, HttpServletRequest request) {
        //查询对应地区的用户
        int count = requirementsDao.countListPublishPage(industryCaseQO);
        if (count == 0) {
            return ResultBody.success(PageResult.buildPage(industryCaseQO.getPageNo(), industryCaseQO.getPageSize(), count));
        }
        Integer pageNo = industryCaseQO.getPageNo();
        industryCaseQO.buildCurrentPage();
        List<RequirementsInfoDO> requirementsInfoDOList = requirementsDao.listPublishPage(industryCaseQO);
        List<RequirementsInfoVO> requirementsInfoVOS = requirementsInfoDOList.stream().map(RequirementsInfoDO::buildRequirementsInfoVO).collect(Collectors.toList());
        Map<Integer, String> collect = requirementsDao.listType().stream().collect(Collectors.toMap(RequirementsTypeDO::getId, d -> d.getTypeName()));
        for (RequirementsInfoVO requirementsInfoVO : requirementsInfoVOS) {
            requirementsInfoVO.setRequirementTypeName(collect.get(requirementsInfoVO.getRequirementTypeId()));
        }
        return ResultBody.success(PageResult.buildPage(pageNo, industryCaseQO.getPageSize(), count, requirementsInfoVOS));
    }

    @Override
    public ResultBody deleteRequire(Integer requirementsInfoId, Integer userAccountId) {
        requirementsDao.removeRequire(requirementsInfoId);
        return ResultBody.success();
    }

    @Override
    public ResultBody updatePublish(RequirementsInfoVO requirementsInfoVO, HttpServletRequest request) {
        RequirementsInfoDO requirementsInfoDO = new RequirementsInfoDO(requirementsInfoVO);
        Integer publish = requirementsDao.findPublish(requirementsInfoDO);
        if (publish == 0) {
            return ResultBody.error(ResultEnum.YOU_CANNOT_MODIFY_REQUIREMENTS_PUBLISHED_BY_OTHERS);
        }
        requirementsDao.updatePublish(requirementsInfoDO);
        return ResultBody.success();
    }

    @Override
    public ResultBody deletePublish(Integer id, Integer userAccountId) {
        Integer publish = requirementsDao.findPublishCount(id, userAccountId);
        if (publish == 0) {
            return ResultBody.error(ResultEnum.YOU_CANNOT_DELETE_REQUIREMENTS_POSTED_BY_OTHERS);
        }
        requirementsDao.requirementsDao(id);
        return ResultBody.success();
    }

    @Override
    public ResultBody appPublishList() {
        List<RequirementsInfoDO> requirementsInfoDOS = requirementsDao.appPublishList();
        //远程调用服务一级分类
        List<IndustryTypeDTO> industryTypeDTOS = listIndustry();
        List<RequirementsInfoVO> collect = requirementsInfoDOS.stream().map(RequirementsInfoDO::buildRequirementsInfoVO).collect(Collectors.toList());
        for (RequirementsInfoVO requirementsInfoVO : collect) {
            for (IndustryTypeDTO industryTypeDTO : industryTypeDTOS) {
                if (requirementsInfoVO.getServiceId() != null && requirementsInfoVO.getServiceId().equals(industryTypeDTO.getId())) {
                    requirementsInfoVO.setServiceName(industryTypeDTO.getTypeName());
                }
            }
        }
        return ResultBody.success(collect);
    }

    @Override
    public ResultBody detailPublish(Integer id, HttpServletRequest request, Integer userAccountId) {
        RequirementsInfoDO requirementsInfoDO = requirementsDao.detailPublish(id);
        RequirementsInfoVO requirementsInfoVO = requirementsInfoDO.buildRequirementsInfoVO();
        if (userAccountId.equals(requirementsInfoVO.getUserAccountId())) {
            requirementsInfoVO.setParamMoney(BigDecimal.valueOf(0.00));
        } else if (!userAccountId.equals(requirementsInfoVO.getUserAccountId())) {
            requirementsInfoVO.setParamMoney(BigDecimal.valueOf(0.10));
        }
        requirementsInfoVO.setOrderNumber(randomOrderCode());
        requirementsInfoVO.setPublishAccountId(requirementsInfoDO.getUserAccountId());
        requirementsInfoVO.setRequirementsInfoId(requirementsInfoDO.getId());
        IndustryTypeDTO industryTypeDTO = pmsAppApi.feignQquerygetIndustryTypeById(requirementsInfoVO.getServiceId());
        requirementsInfoVO.setServiceName(industryTypeDTO.getTypeName());
        //已经支付
        String s = stringRedisTemplate.opsForValue().get(requirementsInfoDO.getId().toString());
        RequirementsInfoVO orderVO = JSON.parseObject(s, RequirementsInfoVO.class);
        if (s != null) {
            if (requirementsInfoDO.getId().equals(orderVO.getRequirementsInfoId()) && userAccountId.equals(orderVO.getUserAccountId())) {
                requirementsInfoVO.setParamMoney(new BigDecimal(0));
                requirementsInfoVO.setOrderNumber(orderVO.getOrderNumber());
                requirementsInfoVO.setPublishPhone("");
                return ResultBody.success(requirementsInfoVO);
            }
        }
        //生成
        ResultBody resultBody = releaseOrder(requirementsInfoVO, request.getHeader("token"));
        if (resultBody.getCode().equals(ResultEnum.THE_THIRD_PARTY_INTERFACE_IS_BEING_UPDATED.getResultCode())) {
            return resultBody;
        }
        if (requirementsInfoVO.getPublish() == 0) {
            requirementsInfoVO.setPublishPhone("");
        }
        return ResultBody.success(requirementsInfoVO);
    }


    @Override
    public ResultBody backDetailPublish(Integer id, HttpServletRequest request, Integer userAccountId) {
        RequirementsInfoDO requirementsInfoDO = requirementsDao.detailPublish(id);
        RequirementsInfoVO requirementsInfoVO = requirementsInfoDO.buildRequirementsInfoVO();
        if (userAccountId.equals(requirementsInfoVO.getUserAccountId())) {
            requirementsInfoVO.setParamMoney(BigDecimal.valueOf(0.00));
        } else if (!userAccountId.equals(requirementsInfoVO.getUserAccountId())) {
            requirementsInfoVO.setParamMoney(BigDecimal.valueOf(0.10));
        }
        requirementsInfoVO.setOrderNumber(randomOrderCode());
        requirementsInfoVO.setPublishAccountId(requirementsInfoDO.getUserAccountId());
        requirementsInfoVO.setRequirementsInfoId(requirementsInfoDO.getId());

        //已经支付
        String s = stringRedisTemplate.opsForValue().get(requirementsInfoDO.getId().toString());
        RequirementsInfoVO orderVO = JSON.parseObject(s, RequirementsInfoVO.class);
        if (s != null) {
            if (requirementsInfoDO.getId().equals(orderVO.getRequirementsInfoId()) && userAccountId.equals(orderVO.getUserAccountId())) {
                requirementsInfoVO.setParamMoney(new BigDecimal(0));
                requirementsInfoVO.setOrderNumber(orderVO.getOrderNumber());
                requirementsInfoVO.setPublishPhone("");
                return ResultBody.success(requirementsInfoVO);
            }
        }

        //生成
        ResultBody resultBody = releaseOrder(requirementsInfoVO, request.getHeader("token"));
        if (resultBody.getCode().equals(ResultEnum.THE_THIRD_PARTY_INTERFACE_IS_BEING_UPDATED.getResultCode())) {
            return resultBody;
        }
        requirementsInfoVO.setPublishPhone("");
        return ResultBody.success(requirementsInfoVO);
    }

    @Override
    public ResultBody<GetOrderNumberDTO> publisherNumber(GetOrderNumberVO getOrderNumberVO, HttpServletRequest request) {
        //用户钱包信息接口
        ResultBody resultBody = getCurrentUserPayWalletInfo(request);
        GetOrderNumberDTO orderNumberDTO = new GetOrderNumberDTO();
        orderNumberDTO.setUserAccountId(getOrderNumberVO.getUserAccountId());
        PayWalletDTO payWalletDTO = (PayWalletDTO) resultBody.getResult();
        //用户云享金+用户佣金>总金额
        //剩余后台云享金
        BigDecimal cashAmt = payWalletDTO.getCashAmt();
        //剩余佣金
        BigDecimal salaryAmt = payWalletDTO.getSalaryAmt();
        //用户云享金加上佣金的总金额
        BigDecimal cashAndSalary = cashAmt.add(salaryAmt);
        //需要支付的总金额
        BigDecimal totalAmount = getOrderNumberVO.getOrderAmount().add(OrderLevelEnum.match(getOrderNumberVO.getOrderLevelEnum().getKey()).getValue());

        if (getOrderNumberVO.getOrderMode() == 2) {
            BigDecimal bigDecimal = new BigDecimal(0.3);
            totalAmount = totalAmount.multiply(bigDecimal).setScale(2, BigDecimal.ROUND_HALF_UP);
        }


        //需要冻结的金额
        WalletFlowVO walletFlowVO = new WalletFlowVO();

        BigDecimal tempTotalAmount = totalAmount;

        String paymentType = getOrderNumberVO.getPaymentType();
        String[] split = paymentType.split(",");
        Set<String> collect = Arrays.asList(split).stream().collect(Collectors.toSet());
        TreeSet<String> objects = new TreeSet<>(collect);
        for (String type : objects) {
            switch (type) {
                case "1":
                    if (!(tempTotalAmount.compareTo(BigDecimal.ZERO) == 0)) {
                        if (cashAmt.compareTo(tempTotalAmount) == 1 || cashAmt.compareTo(tempTotalAmount) == 0) {
                            walletFlowVO.setCashAmount(tempTotalAmount);
                            tempTotalAmount = BigDecimal.ZERO;
                        } else {
                            tempTotalAmount = tempTotalAmount.subtract(cashAmt);
                            walletFlowVO.setCashAmount(cashAmt);
                        }
                    }
                    break;
                case "2":
                    if (!(tempTotalAmount.compareTo(BigDecimal.ZERO) == 0)) {
                        if (salaryAmt.compareTo(tempTotalAmount) == 1 || salaryAmt.compareTo(tempTotalAmount) == 0) {
                            walletFlowVO.setSalaryAmount(tempTotalAmount);
                            tempTotalAmount = BigDecimal.ZERO;
                        } else {
                            tempTotalAmount = tempTotalAmount.subtract(salaryAmt);
                            walletFlowVO.setSalaryAmount(salaryAmt);
                        }
                    }

                    break;
                case "3":
                    if (!(tempTotalAmount.compareTo(BigDecimal.ZERO) == 0)) {
                        walletFlowVO.setWeChat(tempTotalAmount);
                        tempTotalAmount = BigDecimal.ZERO;
                    }
                    break;
                default:
                    break;
            }
        }


        if (tempTotalAmount.compareTo(BigDecimal.ZERO) == 0) {
            //表示订单计算完成，需要支付的钱都算出来了
            walletFlowVO.toString();
            System.out.println(walletFlowVO);
            orderNumberDTO.setWeChatPay(walletFlowVO.getWeChat());
            if (orderNumberDTO.getWeChatPay() != null) {
                orderNumberDTO.setPaymentOrderNumber(randomOrderCode());
            }
            stringRedisTemplate.opsForValue().set(orderNumberDTO.getPaymentOrderNumber(), JsonUtil.parseObjToJson(orderNumberDTO));
            return ResultBody.success(orderNumberDTO);
        } else {
            //云享金和佣金扣除完成，但是还不足支付订单金额，并且没有选择微信支付，所以支付不合法
            return ResultBody.success("下单失败");
        }


      /*  //用户剩余总金额大于需要支付的总金额
        if (cashAndSalary.compareTo(totalAmount) == 1) {
            //优先扣除云享金
            //如果用户选择了云享金没有选择佣金及微信支付
            if (getOrderNumberVO.getCashAmount().compareTo(BigDecimal.ZERO) != 0 &&
                    getOrderNumberVO.getSalaryAmount().compareTo(BigDecimal.ZERO) == 0 &&
                    getOrderNumberVO.getWeChatPay().compareTo(BigDecimal.ZERO) == 0) {
                //如果云享金足够
                if (cashAmt.compareTo(totalAmount) == 1) {
                    //冻结需要支付的金额
                    walletFlowVO.setCashAmount(totalAmount);
                    BigDecimal cashAmount = walletFlowVO.getCashAmount();
                }
                //云享金不够
                if (cashAmt.compareTo(totalAmount) == -1) {
                    return ResultBody.error("请选择多个支付方式，云享金余额不足");
                }
            }
            //选择了佣金 未选择微信支付，云享金
            if (getOrderNumberVO.getCashAmount().compareTo(BigDecimal.ZERO) == 0 &&
                    getOrderNumberVO.getSalaryAmount().compareTo(BigDecimal.ZERO) != 0 &&
                    getOrderNumberVO.getWeChatPay().compareTo(BigDecimal.ZERO) == 0) {
                //佣金足够
                if (salaryAmt.compareTo(totalAmount) == 1) {
                    walletFlowVO.setSalaryAmount(totalAmount);
                    BigDecimal salaryAmount = walletFlowVO.getSalaryAmount();
                }
                //佣金不够
                if (salaryAmt.compareTo(totalAmount) == -1) {
                    return ResultBody.error("请选择多个支付方式，佣金余额不足");
                }
            }
            if (getOrderNumberVO.getCashAmount().compareTo(BigDecimal.ZERO) == 0 &&
                    getOrderNumberVO.getSalaryAmount().compareTo(BigDecimal.ZERO) == 0 &&
                    getOrderNumberVO.getWeChatPay().compareTo(BigDecimal.ZERO) != 0) {
                return ResultBody.error("云享金加上佣金大于需要支付的金额无需使用微信支付");
            }

            //选择了 云享金及佣金支付 没有选择微信支付
            if (getOrderNumberVO.getCashAmount().compareTo(BigDecimal.ZERO) != 0 &&
                    getOrderNumberVO.getSalaryAmount().compareTo(BigDecimal.ZERO) != 0 &&
                    getOrderNumberVO.getWeChatPay().compareTo(BigDecimal.ZERO) == 0) {
                //如果云享金大于总金额
                if (cashAmt.compareTo(totalAmount) == 1) {
                    //云享金就冻结
                    walletFlowVO.setCashAmount(totalAmount.negate());
                    System.out.println(walletFlowVO.getCashAmount());
                }
                //如果云享金不够就扣除佣金
                if (cashAmt.compareTo(totalAmount) == -1) {
                    //总金额减去云享金剩余未扣除的钱
                    BigDecimal subtract = totalAmount.subtract(cashAmt);
                    walletFlowVO.setCashAmount(cashAmt.negate());
                    walletFlowVO.setSalaryAmount(subtract.negate());
                }
                return ResultBody.success("用户剩余总金额足够,需要微信支付");
            }
            //前提是云享金加上佣金大于总金额 选择了云享金 +微信支付
            if (getOrderNumberVO.getCashAmount().compareTo(BigDecimal.ZERO) != 0 &&
                    getOrderNumberVO.getSalaryAmount().compareTo(BigDecimal.ZERO) == 0 &&
                    getOrderNumberVO.getWeChatPay().compareTo(BigDecimal.ZERO) != 0) {
                return ResultBody.error("云享金加上佣金大于需要支付的金额无需使用微信支付");
            }


            //前提是云享金加上佣金大于总金额 选择了佣金+选择了微信支付
            if (getOrderNumberVO.getCashAmount().compareTo(BigDecimal.ZERO) == 0 &&
                    getOrderNumberVO.getSalaryAmount().compareTo(BigDecimal.ZERO) != 0 &&
                    getOrderNumberVO.getWeChatPay().compareTo(BigDecimal.ZERO) != 0) {
                return ResultBody.error("云享金加上佣金大于需要支付的金额无需使用微信支付");
            }
            if (getOrderNumberVO.getCashAmount().compareTo(BigDecimal.ZERO) != 0 &&
                    getOrderNumberVO.getSalaryAmount().compareTo(BigDecimal.ZERO) != 0 &&
                    getOrderNumberVO.getWeChatPay().compareTo(BigDecimal.ZERO) != 0) {
                return ResultBody.error("云享金加上佣金大于需要支付的金额,请取消微信支付");
            }
        }
        //用户剩余总金额小于需要支付的总金额
        if (cashAndSalary.compareTo(totalAmount) == -1) {
            //用户剩余的总金额小于需要支付的总金额 只选择了云享金支付
            if (getOrderNumberVO.getCashAmount().compareTo(BigDecimal.ZERO) != 0 &&
                    getOrderNumberVO.getSalaryAmount().compareTo(BigDecimal.ZERO) == 0 &&
                    getOrderNumberVO.getWeChatPay().compareTo(BigDecimal.ZERO) == 0) {
                //云享金不够
                if (cashAmt.compareTo(totalAmount) == -1) {
                    return ResultBody.error("请选择多个支付方式，云享金余额不足");
                }
            }
            //用户剩余的总金额小于需要支付的总金额 选择了佣金 未选择微信支付，云享金
            if (getOrderNumberVO.getCashAmount().compareTo(BigDecimal.ZERO) == 0 &&
                    getOrderNumberVO.getSalaryAmount().compareTo(BigDecimal.ZERO) != 0 &&
                    getOrderNumberVO.getWeChatPay().compareTo(BigDecimal.ZERO) == 0) {
                //佣金不够
                if (salaryAmt.compareTo(totalAmount) == -1) {
                    return ResultBody.error("请选择多个支付方式，佣金余额不足");
                }
            }
            if (getOrderNumberVO.getCashAmount().compareTo(BigDecimal.ZERO) == 0 &&
                    getOrderNumberVO.getSalaryAmount().compareTo(BigDecimal.ZERO) == 0 &&
                    getOrderNumberVO.getWeChatPay().compareTo(BigDecimal.ZERO) != 0) {
                //微信实际需要全部支付
                orderNumberDTO.setWeChatPay(totalAmount);
                orderNumberDTO.setPaymentOrderNumber(randomOrderCode());
                stringRedisTemplate.opsForValue().set(orderNumberDTO.getPaymentOrderNumber(), JsonUtil.parseObjToJson(orderNumberDTO));
                return ResultBody.success(orderNumberDTO);
            }
            //用户剩余的总金额小于需要支付的总金额 云享金及佣金支付 没有选择微信支付
            if (getOrderNumberVO.getCashAmount().compareTo(BigDecimal.ZERO) != 0 &&
                    getOrderNumberVO.getSalaryAmount().compareTo(BigDecimal.ZERO) != 0 &&
                    getOrderNumberVO.getWeChatPay().compareTo(BigDecimal.ZERO) == 0) {

                return ResultBody.error("云享金加上佣金小于需要总金额，需要加上微信支付");
            }
            //用户剩余的总金额小于需要支付的总金额 选择了云享金 +微信支付
            if (getOrderNumberVO.getCashAmount().compareTo(BigDecimal.ZERO) != 0 &&
                    getOrderNumberVO.getSalaryAmount().compareTo(BigDecimal.ZERO) == 0 &&
                    getOrderNumberVO.getWeChatPay().compareTo(BigDecimal.ZERO) != 0) {

                BigDecimal weChat = totalAmount.subtract(cashAmt);

                //微信实际需要全部支付
                //云享金需要冻结的金额
                walletFlowVO.setCashAmount(cashAmt);
                orderNumberDTO.setWeChatPay(weChat);
                orderNumberDTO.setPaymentOrderNumber(randomOrderCode());
                stringRedisTemplate.opsForValue().set(orderNumberDTO.getPaymentOrderNumber(), JsonUtil.parseObjToJson(orderNumberDTO));
                return ResultBody.success(orderNumberDTO);
            }


            //用户剩余的总金额小于需要支付的总金额 选择了佣金+选择了微信支付
            if (getOrderNumberVO.getCashAmount().compareTo(BigDecimal.ZERO) == 0 &&
                    getOrderNumberVO.getSalaryAmount().compareTo(BigDecimal.ZERO) != 0 &&
                    getOrderNumberVO.getWeChatPay().compareTo(BigDecimal.ZERO) != 0) {

                BigDecimal weChat = totalAmount.subtract(salaryAmt);

                //需要冻结的佣金是
                walletFlowVO.setSalaryAmount(salaryAmt);
                //微信需要支付的金额
                orderNumberDTO.setWeChatPay(weChat);
                stringRedisTemplate.opsForValue().set(orderNumberDTO.getPaymentOrderNumber(), JsonUtil.parseObjToJson(orderNumberDTO));
                return ResultBody.success(orderNumberDTO);
            }
            if (getOrderNumberVO.getCashAmount().compareTo(BigDecimal.ZERO) != 0 &&
                    getOrderNumberVO.getSalaryAmount().compareTo(BigDecimal.ZERO) != 0 &&
                    getOrderNumberVO.getWeChatPay().compareTo(BigDecimal.ZERO) != 0) {
                //优先扣除云享金
                BigDecimal totalSubtract = totalAmount.subtract(cashAmt);
                BigDecimal salarySubtract = totalSubtract.subtract(salaryAmt);
                walletFlowVO.setWeChat(salarySubtract);
                orderNumberDTO.setWeChatPay(salarySubtract);
                orderNumberDTO.setPaymentOrderNumber(randomOrderCode());
                stringRedisTemplate.opsForValue().set(orderNumberDTO.getPaymentOrderNumber(), JsonUtil.parseObjToJson(orderNumberDTO));
                return ResultBody.success(orderNumberDTO);
            }
        }

*/
    /*    //云享金
        BigDecimal cashAmount = getOrderNumberVO.getCashAmount();
        //佣金
        BigDecimal salaryAmount = getOrderNumberVO.getSalaryAmount();
        //微信金额
        BigDecimal weChat = getOrderNumberVO.getWeChatPay();

        String randomOrder = randomOrderCode();
        if (cashAmount.equals(BigDecimal.ZERO) && salaryAmount.equals(BigDecimal.ZERO) && weChat.equals(BigDecimal.ZERO)) {
            return ResultBody.error(ResultEnum.PLEASE_SELECT_PAYMENT);
        }
        if (!cashAmount.equals(BigDecimal.ZERO) && salaryAmount.equals(BigDecimal.ZERO) && weChat.equals(BigDecimal.ZERO)) {
            //总金额大于云享金剩余的金额
            if (totalAmount.compareTo(cashAmt) == 1) {
                return ResultBody.error(ResultEnum.OVER_THE_TOTAL);
            }
        }
        if (cashAmount.equals(BigDecimal.ZERO) && !salaryAmount.equals(BigDecimal.ZERO) && weChat.equals(BigDecimal.ZERO)) {
            //总金额大于佣金剩余的金额
            if (totalAmount.compareTo(salaryAmt) == 1) {
                return ResultBody.error(ResultEnum.SALARY_PAYMENT_FAILURE);
            }
        }
        //单独微信微信 可以进行支付
        if (cashAmount.equals(BigDecimal.ZERO) && salaryAmount.equals(BigDecimal.ZERO) && !weChat.equals(BigDecimal.ZERO)) {
            orderNumberDTO.setWeChatPay(totalAmount);
            orderNumberDTO.setPaymentOrderNumber(randomOrder);
            return ResultBody.success(orderNumberDTO);
        }
        if (!cashAmount.equals(BigDecimal.ZERO) && !salaryAmount.equals(BigDecimal.ZERO) && weChat.equals(BigDecimal.ZERO)) {
            BigDecimal add = cashAmt.add(salaryAmt);
            if (totalAmount.compareTo(add) == 1) {
                return ResultBody.error(ResultEnum.CASH_SALARY_PAYMENT_FAILURE);
            }
        }
        if (!cashAmount.equals(BigDecimal.ZERO) && salaryAmount.equals(BigDecimal.ZERO) && !weChat.equals(BigDecimal.ZERO)) {
            BigDecimal subtract = totalAmount.subtract(cashAmt);
            orderNumberDTO.setWeChatPay(subtract);
            orderNumberDTO.setPaymentOrderNumber(randomOrder);
            return ResultBody.success(orderNumberDTO);
        }
        if (cashAmount.equals(BigDecimal.ZERO) && !salaryAmount.equals(BigDecimal.ZERO) && !weChat.equals(BigDecimal.ZERO)) {
            BigDecimal subtract = totalAmount.subtract(salaryAmt);
            orderNumberDTO.setWeChatPay(subtract);
            orderNumberDTO.setPaymentOrderNumber(randomOrder);
            return ResultBody.success(orderNumberDTO);
        }
        if (!cashAmount.equals(BigDecimal.ZERO) && !salaryAmount.equals(BigDecimal.ZERO) && !weChat.equals(BigDecimal.ZERO)) {
            BigDecimal cashAndSalary = cashAmt.add(salaryAmt);
            BigDecimal cash = totalAmount.subtract(cashAmt);
            if (cash.compareTo(BigDecimal.ZERO) == 0) {
                return ResultBody.error(ResultEnum.CASH_IS_ENOUGH);
            }
            BigDecimal salary = cash.subtract(salaryAmt);
            if (salary.compareTo(BigDecimal.ZERO) == 0) {
                return ResultBody.error(ResultEnum.SALARY_IS_ENOUGH);
            }
             return ResultBody.success(orderNumberDTO);
        }*/


    }

    @Override
    public ResultBody<RequirementsInfoVO> myPreempt(Integer userAccountId) {
        List<RequirementsInfoDO> requirementsInfoDOS = requirementsDao.myPreempt(userAccountId);
        List<RequirementsInfoVO> collect = requirementsInfoDOS.stream().map(RequirementsInfoDO::buildRequirementsInfoVO).collect(Collectors.toList());
        return ResultBody.success(collect);
    }

    @Override
    public ResultBody publishService(ServiceRequirementsVO serviceRequirementsVO, HttpServletRequest request) {

        //需要冻结的金额
        WalletFlowVO walletFlowVO = new WalletFlowVO();
        ServiceRequirementsDO requirementsInfoDO = new ServiceRequirementsDO(serviceRequirementsVO);
        requirementsInfoDO.setPublisherNumber(randomOrderCode());

        //获取用户钱包
        ResultBody resultBody = getCurrentUserPayWalletInfo(request);
        PayWalletDTO payWalletDTO = (PayWalletDTO) resultBody.getResult();

        //需要支付的总金额
        BigDecimal totalAmount = requirementsInfoDO.getTotalAmount();
        //云享金
        BigDecimal cashAmt = payWalletDTO.getCashAmt();
        //佣金
        BigDecimal salaryAmt = payWalletDTO.getSalaryAmt();

        String json = stringRedisTemplate.opsForValue().get(requirementsInfoDO.getWechatPayOrderNumber() + requirementsInfoDO.getUserAccountId());
        GetOrderNumberDTO orderNumberDTO = JSONObject.parseObject(json, GetOrderNumberDTO.class);

        BigDecimal tempTotalAmount = totalAmount;

        String paymentType = requirementsInfoDO.getPaymentType();
        String[] split = paymentType.split(",");
        Set<String> collect = Arrays.asList(split).stream().collect(Collectors.toSet());
        TreeSet<String> objects = new TreeSet<>(collect);
        for (String type : objects) {
            switch (type) {
                case "1":
                    if (!(tempTotalAmount.compareTo(BigDecimal.ZERO) == 0)) {
                        if (cashAmt.compareTo(tempTotalAmount) == 1 || cashAmt.compareTo(tempTotalAmount) == 0) {
                            walletFlowVO.setCashAmount(tempTotalAmount);
                            tempTotalAmount = BigDecimal.ZERO;
                        } else {
                            tempTotalAmount = tempTotalAmount.subtract(cashAmt);
                            walletFlowVO.setCashAmount(cashAmt);
                        }
                    }
                    break;
                case "2":
                    if (!(tempTotalAmount.compareTo(BigDecimal.ZERO) == 0)) {
                        if (salaryAmt.compareTo(tempTotalAmount) == 1 || salaryAmt.compareTo(tempTotalAmount) == 0) {
                            walletFlowVO.setSalaryAmount(tempTotalAmount);
                            tempTotalAmount = BigDecimal.ZERO;
                        } else {
                            tempTotalAmount = tempTotalAmount.subtract(salaryAmt);
                            walletFlowVO.setSalaryAmount(salaryAmt);
                        }
                    }

                    break;
                case "3":
                    if (!(tempTotalAmount.compareTo(BigDecimal.ZERO) == 0)) {
                        walletFlowVO.setWeChat(tempTotalAmount);
                        tempTotalAmount = BigDecimal.ZERO;
                    }
                    break;
                default:
                    break;
            }
        }
        if (tempTotalAmount.compareTo(BigDecimal.ZERO) == 0) {
            //表示订单计算完成，需要支付的钱都算出来了
            walletFlowVO.toString();
            System.out.println(walletFlowVO);
            //orderNumberDTO.setWeChatPay(walletFlowVO.getWeChat());
            /*if (orderNumberDTO.getWeChatPay() != null) {
                orderNumberDTO.setPaymentOrderNumber(randomOrderCode());
            }*/
            requirementsInfoDO.setCashAmount(walletFlowVO.getCashAmount());
            requirementsInfoDO.setSalaryAmount(walletFlowVO.getSalaryAmount());
            requirementsInfoDO.setWeChat(walletFlowVO.getWeChat());
            if (orderNumberDTO != null) {
                requirementsInfoDO.setWechatPayOrderNumber(orderNumberDTO.getPaymentOrderNumber());
            } else if (orderNumberDTO == null) {
                requirementsInfoDO.setWechatPayOrderNumber(null);
            }
            requirementsDao.addPublishService(requirementsInfoDO);
            return ResultBody.success();
        } else {
            //云享金和佣金扣除完成，但是还不足支付订单金额，并且没有选择微信支付，所以支付不合法
            return ResultBody.success("下单失败");
        }
       /* if (cashAmount.equals(BigDecimal.ZERO) && salaryAmount.equals(BigDecimal.ZERO) && weChat.equals(BigDecimal.ZERO)) {
            return ResultBody.error(ResultEnum.PLEASE_SELECT_PAYMENT);
        }
        if (!cashAmount.equals(BigDecimal.ZERO) && salaryAmount.equals(BigDecimal.ZERO) && weChat.equals(BigDecimal.ZERO)) {
            //总金额大于云享金剩余的金额
            if (totalAmount.compareTo(cashAmt) == 1) {
                return ResultBody.error(ResultEnum.OVER_THE_TOTAL);
            }
            //总金额小于云享金剩余的金额
            if (totalAmount.compareTo(cashAmt) == -1) {

                walletFlowVO.setCashAmount(totalAmount);
            }
            walletFlowVO.setCashAmount(totalAmount.negate());
            //冻结云享金
            extracted(walletFlowVO, requirementsInfoDO);
        }
        if (cashAmount.equals(BigDecimal.ZERO) && !salaryAmount.equals(BigDecimal.ZERO) && weChat.equals(BigDecimal.ZERO)) {
            //总金额大于佣金剩余的金额
            if (totalAmount.compareTo(salaryAmt) == 1) {
                return ResultBody.error(ResultEnum.SALARY_PAYMENT_FAILURE);
            }
            //总金额小于佣金剩余的金额
            if (totalAmount.compareTo(salaryAmount) == -1) {
                walletFlowVO.setSalaryAmount(totalAmount);
            }
            walletFlowVO.setSalaryAmount(totalAmount.negate());
            extracted(walletFlowVO, requirementsInfoDO);
        }
        //单独微信制度 可以进行支付
        if (cashAmount.equals(BigDecimal.ZERO) && salaryAmount.equals(BigDecimal.ZERO) && !weChat.equals(BigDecimal.ZERO)) {
            BigDecimal weChatPay = orderNumberDTO.getWeChatPay().negate();
            walletFlowVO.setWeChat(weChatPay);
            extracted(walletFlowVO, requirementsInfoDO);
        }
        //云享金与佣金剩余金额足够及不足够
        if (!cashAmount.equals(BigDecimal.ZERO) && !salaryAmount.equals(BigDecimal.ZERO) && weChat.equals(BigDecimal.ZERO)) {
            BigDecimal add = cashAmt.add(salaryAmt);
            if (totalAmount.compareTo(add) == 1) {
                return ResultBody.error(ResultEnum.CASH_SALARY_PAYMENT_FAILURE);
            }
            //云享金不足佣金可以补上
            if (totalAmount.compareTo(add) == -1) {
                BigDecimal cash = cashAmt.subtract(totalAmount);
                if (cash.compareTo(BigDecimal.ZERO) <= 0) {
                    BigDecimal salary = salaryAmt.subtract(cash.negate());
                    System.out.println(salary);
                    //云享金
                    walletFlowVO.setCashAmount(cashAmt.negate());
                    walletFlowVO.setSalaryAmount(cashAmt.negate());
                    extracted(walletFlowVO, requirementsInfoDO);
                }
                //云享金足够 不扣除佣金剩余的金额
                if (cash.compareTo(BigDecimal.ZERO) > 0) {
                    walletFlowVO.setCashAmount(cash.negate());
                    extracted(walletFlowVO, requirementsInfoDO);
                }
            }
        }
        //选择佣金或者微信支付
        if (cashAmount.equals(BigDecimal.ZERO) && !salaryAmount.equals(BigDecimal.ZERO) && !weChat.equals(BigDecimal.ZERO)) {

            BigDecimal salary = salaryAmt.subtract(totalAmount);

            if (salary.compareTo(BigDecimal.ZERO) >= 0) {
                walletFlowVO.setSalaryAmount(totalAmount);
                extracted(walletFlowVO, requirementsInfoDO);
            }
            if (salary.compareTo(BigDecimal.ZERO) < 0) {
                BigDecimal weChatPay = orderNumberDTO.getWeChatPay();
                walletFlowVO.setSalaryAmount(salary);
                walletFlowVO.setWeChat(weChatPay.negate());
                extracted(walletFlowVO, requirementsInfoDO);
            }
            return ResultBody.success(orderNumberDTO);
        }

        if (!cashAmount.equals(BigDecimal.ZERO) && !salaryAmount.equals(BigDecimal.ZERO) && !weChat.equals(BigDecimal.ZERO)) {
            BigDecimal cash = cashAmt.subtract(totalAmount);
            BigDecimal salary = salaryAmt.subtract(cash.negate());
            // 如果云享金充足
            if (cash.compareTo(BigDecimal.ZERO) >= 0) {
                walletFlowVO.setCashAmount(totalAmount);
            }
            if (cash.compareTo(BigDecimal.ZERO) < 0 && salary.compareTo(BigDecimal.ZERO) >= 0) {
                walletFlowVO.setCashAmount(cashAmt.negate());
                walletFlowVO.setSalaryAmount(cash);
                extracted(walletFlowVO, requirementsInfoDO);
            }
            if (cash.compareTo(BigDecimal.ZERO) < 0 && salary.compareTo(BigDecimal.ZERO) < 0) {
                walletFlowVO.setCashAmount(cashAmt);
                walletFlowVO.setSalaryAmount(salaryAmt);
                walletFlowVO.setWeChat(orderNumberDTO.getWeChatPay());
            }
        }
*/

    }

    private void extracted(WalletFlowVO walletFlowVO, ServiceRequirementsDO requirementsInfoDO) {
        SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");// 设置日期格式
        walletFlowVO.setWeChat(walletFlowVO.getWeChat());
        walletFlowVO.setModeOfPayment(300);
        walletFlowVO.setTimeOfPayment(df.format(new Date()));
        walletFlowVO.setUserAccountId(requirementsInfoDO.getUserAccountId());
        walletFlowVO.setOperateUserAccountId(requirementsInfoDO.getUserAccountId());
        walletFlowVO.setCashAmount(walletFlowVO.getCashAmount());
        walletFlowVO.setSalaryAmount(walletFlowVO.getSalaryAmount());
        System.out.println(walletFlowVO);
    }

    /**
     * 获取用户钱包信息
     *
     * @param
     * @param request
     * @return
     */
    public ResultBody getCurrentUserPayWalletInfo(HttpServletRequest request) {
        String token = request.getHeader("token");
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        headers.add("token", token);
        HttpEntity<MultiValueMap<String, Object>> formEntity = new HttpEntity<MultiValueMap<String, Object>>(headers);
        ResponseEntity<String> exchange = null;
        try {
            exchange = restTemplate.exchange(userApp + "/userapp/pay/getCurrentUserPayWalletInfo", HttpMethod.GET, formEntity, String.class);
        } catch (RestClientException e) {
            return ResultBody.error(ResultEnum.THE_THIRD_PARTY_INTERFACE_IS_BEING_UPDATED);
        }
        Object body = exchange.getBody();
        JSONObject jsonObject = JSONObject.parseObject((String) body);
        JSONObject result1 = (JSONObject) jsonObject.get("result");
        PayWalletDTO payWalletDTO = JSON.parseObject(result1.toJSONString(), PayWalletDTO.class);
        return ResultBody.success(payWalletDTO);
    }


    @Override
    public ResultBody<RequirementsInfoVO> myPublish(Integer userAccountId) {
        List<RequirementsInfoDO> requirementsInfoDOS = requirementsDao.myPublish(userAccountId);
        List<RequirementsInfoVO> collect = requirementsInfoDOS.stream().map(RequirementsInfoDO::buildRequirementsInfoVO).collect(Collectors.toList());
        return ResultBody.success(collect);

    }


    @Override
    public ResultBody grabTheOrder(GrabTheOrderVO grabTheOrderVO, HttpServletRequest request) {

        ServiceRequirementsDO requirementsInfoDO = requirementsDao.grabTheOrder(grabTheOrderVO.getPublisherNumber());
        if (grabTheOrderVO.getPublisherNumber().equals(requirementsInfoDO.getPublisherNumber()) && grabTheOrderVO.getUserAccountId().equals(requirementsInfoDO.getUserAccountId())) {
            return ResultBody.error("自己不能抢自己发布的需求");
        }
        //飞手
        PilotCertificationInteriorDTO pilot = feignInteriorDetailPilot(grabTheOrderVO.getUserAccountId(), request);
        if (pilot == null) {
            return ResultBody.error("只能飞手或者飞手团队抢单");
        }

        Integer repertory = requirementsInfoDO.getRepertory();
        if (repertory <= 0) {
            return ResultBody.error("需求已被其他人抢走");
        }

        //  requirementsInfoDO.setPublisherNumber(randomOrderCode());
        ResultBody resultBody = getCurrentUserPayWalletInfo(request);
        PayWalletDTO payWalletDTO = (PayWalletDTO) resultBody.getResult();


        //用户云享金+用户佣金>总金额
        //剩余后台云享金
        BigDecimal cashAmt = payWalletDTO.getCashAmt();
        //剩余佣金
        BigDecimal salaryAmt = payWalletDTO.getSalaryAmt();
        //用户云享金加上佣金的总金额
        BigDecimal cashAndSalary = cashAmt.add(salaryAmt);
        //需要支付的总金额
        BigDecimal totalAmount = requirementsInfoDO.getTotalAmount();
        BigDecimal bigDecimal = new BigDecimal(0.3);
        totalAmount = totalAmount.multiply(bigDecimal).setScale(2, BigDecimal.ROUND_HALF_UP);
        String json = stringRedisTemplate.opsForValue().get(requirementsInfoDO.getWechatPayOrderNumber() + requirementsInfoDO.getUserAccountId());
        GetOrderNumberDTO orderNumberDTO = JSONObject.parseObject(json, GetOrderNumberDTO.class);
        //需要冻结的金额
        WalletFlowVO walletFlowVO = new WalletFlowVO();
        BigDecimal tempTotalAmount = totalAmount;
        String paymentType = grabTheOrderVO.getPaymentType();
        String[] split = paymentType.split(",");
        Set<String> collect = Arrays.asList(split).stream().collect(Collectors.toSet());
        TreeSet<String> objects = new TreeSet<>(collect);
        for (String type : objects) {
            switch (type) {
                case "1":
                    if (!(tempTotalAmount.compareTo(BigDecimal.ZERO) == 0)) {
                        if (cashAmt.compareTo(tempTotalAmount) == 1 || cashAmt.compareTo(tempTotalAmount) == 0) {
                            walletFlowVO.setCashAmount(tempTotalAmount);
                            tempTotalAmount = BigDecimal.ZERO;
                        } else {
                            tempTotalAmount = tempTotalAmount.subtract(cashAmt);
                            walletFlowVO.setCashAmount(cashAmt);
                        }
                    }
                    break;
                case "2":
                    if (!(tempTotalAmount.compareTo(BigDecimal.ZERO) == 0)) {
                        if (salaryAmt.compareTo(tempTotalAmount) == 1 || salaryAmt.compareTo(tempTotalAmount) == 0) {
                            walletFlowVO.setSalaryAmount(tempTotalAmount);
                            tempTotalAmount = BigDecimal.ZERO;
                        } else {
                            tempTotalAmount = tempTotalAmount.subtract(salaryAmt);
                            walletFlowVO.setSalaryAmount(salaryAmt);
                        }
                    }
                    break;
                case "3":
                    if (!(tempTotalAmount.compareTo(BigDecimal.ZERO) == 0)) {
                        walletFlowVO.setWeChat(tempTotalAmount);
                        tempTotalAmount = BigDecimal.ZERO;
                    }
                    break;
                default:
                    break;
            }
        }
        if (tempTotalAmount.compareTo(BigDecimal.ZERO) == 0) {
            //表示订单计算完成，需要支付的钱都算出来了
            walletFlowVO.toString();
            System.out.println(walletFlowVO);
         /*   orderNumberDTO.setWeChatPay(walletFlowVO.getWeChat());
            if (orderNumberDTO.getWeChatPay() != null) {
                orderNumberDTO.setPaymentOrderNumber(randomOrderCode());
            }*/
            // return ResultBody.success(orderNumberDTO);
             /* //云享金
        BigDecimal cashAmount = requirementsInfoDO.getCashAmount();
        //佣金
        BigDecimal salaryAmount = requirementsInfoDO.getSalaryAmount();
        //微信金额
        BigDecimal weChat = requirementsInfoDO.getWeChat();
        //需要支付的总金额
        BigDecimal totalAmount = requirementsInfoDO.getTotalAmount();
        System.out.println(totalAmount);
        totalAmount = totalAmount.multiply(new BigDecimal(0.3));
        //云享金
        BigDecimal cashAmt = payWalletDTO.getCashAmt();
        //佣金
        BigDecimal salaryAmt = payWalletDTO.getSalaryAmt();
        String json = stringRedisTemplate.opsForValue().get(requirementsInfoDO.getWechatPayOrderNumber() + requirementsInfoDO.getUserAccountId());
        GetOrderNumberDTO orderNumberDTO = JSONObject.parseObject(json, GetOrderNumberDTO.class);
        if (cashAmount.equals(BigDecimal.ZERO) && salaryAmount.equals(BigDecimal.ZERO) && weChat.equals(BigDecimal.ZERO)) {
            return ResultBody.error(ResultEnum.PLEASE_SELECT_PAYMENT);
        }
        if (!cashAmount.equals(BigDecimal.ZERO) && salaryAmount.equals(BigDecimal.ZERO) && weChat.equals(BigDecimal.ZERO)) {
            //总金额大于云享金剩余的金额
            if (totalAmount.compareTo(cashAmt) == 1) {
                return ResultBody.error(ResultEnum.OVER_THE_TOTAL);
            }
            //总金额小于云享金剩余的金额
            if (totalAmount.compareTo(cashAmt) == -1) {

                walletFlowVO.setCashAmount(totalAmount);
            }
            walletFlowVO.setCashAmount(totalAmount.negate());
            //冻结云享金
            extracted(walletFlowVO, requirementsInfoDO);
        }
        if (cashAmount.equals(BigDecimal.ZERO) && !salaryAmount.equals(BigDecimal.ZERO) && weChat.equals(BigDecimal.ZERO)) {
            //总金额大于佣金剩余的金额
            if (totalAmount.compareTo(salaryAmt) == 1) {
                return ResultBody.error(ResultEnum.SALARY_PAYMENT_FAILURE);
            }
            //总金额小于佣金剩余的金额
            if (totalAmount.compareTo(salaryAmount) == -1) {
                walletFlowVO.setSalaryAmount(totalAmount);
            }
            walletFlowVO.setSalaryAmount(totalAmount.negate());
            extracted(walletFlowVO, requirementsInfoDO);
        }
        //单独微信制度 可以进行支付
        if (cashAmount.equals(BigDecimal.ZERO) && salaryAmount.equals(BigDecimal.ZERO) && !weChat.equals(BigDecimal.ZERO)) {
            BigDecimal weChatPay = orderNumberDTO.getWeChatPay().negate();
            walletFlowVO.setWeChat(weChatPay);
            extracted(walletFlowVO, requirementsInfoDO);
        }
        //云享金与佣金剩余金额足够及不足够
        if (!cashAmount.equals(BigDecimal.ZERO) && !salaryAmount.equals(BigDecimal.ZERO) && weChat.equals(BigDecimal.ZERO)) {
            BigDecimal add = cashAmt.add(salaryAmt);
            if (totalAmount.compareTo(add) == 1) {
                return ResultBody.error(ResultEnum.CASH_SALARY_PAYMENT_FAILURE);
            }
            //云享金不足佣金可以补上
            if (totalAmount.compareTo(add) == -1) {
                BigDecimal cash = cashAmt.subtract(totalAmount);
                if (cash.compareTo(BigDecimal.ZERO) <= 0) {
                    BigDecimal salary = salaryAmt.subtract(cash.negate());
                    System.out.println(salary);
                    //云享金
                    walletFlowVO.setCashAmount(cashAmt.negate());
                    walletFlowVO.setSalaryAmount(cashAmt.negate());
                    extracted(walletFlowVO, requirementsInfoDO);
                }
                //云享金足够 不扣除佣金剩余的金额
                if (cash.compareTo(BigDecimal.ZERO) > 0) {
                    walletFlowVO.setCashAmount(cash.negate());
                    extracted(walletFlowVO, requirementsInfoDO);
                }
            }
        }
        //选择佣金或者微信支付
        if (cashAmount.equals(BigDecimal.ZERO) && !salaryAmount.equals(BigDecimal.ZERO) && !weChat.equals(BigDecimal.ZERO)) {

            BigDecimal salary = salaryAmt.subtract(totalAmount);

            if (salary.compareTo(BigDecimal.ZERO) >= 0) {
                walletFlowVO.setSalaryAmount(totalAmount);
                extracted(walletFlowVO, requirementsInfoDO);
            }
            if (salary.compareTo(BigDecimal.ZERO) < 0) {
                BigDecimal weChatPay = orderNumberDTO.getWeChatPay();
                walletFlowVO.setSalaryAmount(salary);
                walletFlowVO.setWeChat(weChatPay.negate());
                extracted(walletFlowVO, requirementsInfoDO);
            }
            return ResultBody.success(orderNumberDTO);
        }
        if (!cashAmount.equals(BigDecimal.ZERO) && !salaryAmount.equals(BigDecimal.ZERO) && !weChat.equals(BigDecimal.ZERO)) {
            BigDecimal cash = cashAmt.subtract(totalAmount);
            BigDecimal salary = salaryAmt.subtract(cash.negate());
            // 如果云享金充足
            if (cash.compareTo(BigDecimal.ZERO) >= 0) {
                walletFlowVO.setCashAmount(totalAmount);
            }
            if (cash.compareTo(BigDecimal.ZERO) < 0 && salary.compareTo(BigDecimal.ZERO) >= 0) {
                walletFlowVO.setCashAmount(cashAmt.negate());
                walletFlowVO.setSalaryAmount(cash);
                extracted(walletFlowVO, requirementsInfoDO);
            }
            if (cash.compareTo(BigDecimal.ZERO) < 0 && salary.compareTo(BigDecimal.ZERO) < 0) {
                walletFlowVO.setCashAmount(cashAmt);
                walletFlowVO.setSalaryAmount(salaryAmt);
                walletFlowVO.setWeChat(orderNumberDTO.getWeChatPay());
            }
        }*/
            RequirementsServiceDO requirementsServiceDO = new RequirementsServiceDO(pilot, requirementsInfoDO);
            requirementsServiceDO.setCashAmount(walletFlowVO.getCashAmount());
            requirementsServiceDO.setSalaryAmount(walletFlowVO.getSalaryAmount());
            requirementsServiceDO.setWeChat(orderNumberDTO.getWeChatPay());
            requirementsServiceDO.setWechatPayOrderNumber(orderNumberDTO.getPaymentOrderNumber());
            BigDecimal cashAndSalaryAmount = walletFlowVO.getCashAmount().add(walletFlowVO.getSalaryAmount());
            BigDecimal preemptTotalAmount = cashAndSalaryAmount.add(orderNumberDTO.getWeChatPay());
            requirementsServiceDO.setPreemptTotalAmount(preemptTotalAmount);
            requirementsDao.insertService(requirementsServiceDO);
            requirementsInfoDO.setRepertory(repertory - 1);
            requirementsDao.updateGrabTheOrder(grabTheOrderVO.getPublisherNumber(), requirementsInfoDO.getRepertory());
            return ResultBody.success();
        } else {
            //云享金和佣金扣除完成，但是还不足支付订单金额，并且没有选择微信支付，所以支付不合法
            return ResultBody.success("抢单失败");
        }
    }


    @Override
    public ResultBody arriveAtTheScene(ServiceArriveSceneVO serviceArriveSceneVO) {
        ServiceArriveSceneDO serviceArriveSceneDO = new ServiceArriveSceneDO(serviceArriveSceneVO);
        RequirementsInfoDO requirementsInfoDO = requirementsDao.detailPublish(serviceArriveSceneDO.getRequirementsInfoId());
        GlobalCoordinates source = new GlobalCoordinates(Double.parseDouble(String.valueOf(requirementsInfoDO.getLatitude())), Double.parseDouble(String.valueOf(requirementsInfoDO.getLongitude())));
        GlobalCoordinates target = new GlobalCoordinates(Double.parseDouble(String.valueOf(serviceArriveSceneDO.getLatitude())), Double.parseDouble(String.valueOf(serviceArriveSceneDO.getLongitude())));
        double geoCurve = getDistanceMeter(source, target, Ellipsoid.Sphere);
        //100米
        if (geoCurve > 100) {
            return ResultBody.error(ResultEnum.FALL_OUTSIDE_OF);
        } else {
            requirementsDao.arriveAtTheScene(serviceArriveSceneDO);
            requirementsDao.updateScene(serviceArriveSceneDO.getRequirementsInfoId());
        }
        return ResultBody.success();
    }

    /* 经纬度计算工具类*/
    public static double getDistanceMeter(GlobalCoordinates gpsFrom, GlobalCoordinates gpsTo, Ellipsoid ellipsoid) {
        //创建GeodeticCalculator，调用计算方法，传入坐标系、经纬度用于计算距离
        GeodeticCurve geoCurve = new GeodeticCalculator().calculateGeodeticCurve(ellipsoid, gpsFrom, gpsTo);
        return geoCurve.getEllipsoidalDistance();
    }

    @Override
    public ResultBody<ServiceArriveSceneDTO> arriveAtTheSceneDetails(Integer requirementsInfoId, Integer userAccountId) {
        ServiceArriveSceneDO serviceArriveSceneDO = requirementsDao.arriveAtTheSceneDetails(requirementsInfoId, userAccountId);
        ServiceArriveSceneDTO serviceArriveSceneDTO = serviceArriveSceneDO.buildServiceArriveSceneDTO();
        return ResultBody.success(serviceArriveSceneDTO);
    }


    @Override
    public ResultBody fulfilATask(ServiceFulfilATaskVO fulfilATaskVO) {
        ServiceFulfilATaskDO serviceFulfilATaskDO = new ServiceFulfilATaskDO(fulfilATaskVO);
        requirementsDao.fulfilATask(serviceFulfilATaskDO);
        requirementsDao.updateFulfilATask(fulfilATaskVO.getRequirementsInfoId());
        return ResultBody.success();
    }

    @Override
    public ResultBody<ServiceFulfilATaskDTO> fulfilATaskDetails(Integer requirementsInfoId, Integer userAccountId) {
        ServiceFulfilATaskDO serviceFulfilATaskDO = requirementsDao.fulfilATaskDetails(requirementsInfoId, userAccountId);
        ServiceFulfilATaskDTO serviceFulfilATaskDTO = serviceFulfilATaskDO.buildServiceFulfilATaskDTO();
        return ResultBody.success(serviceFulfilATaskDTO);
    }


    @Override
    public ResultBody settleAccounts(ServiceSettleAccountsVO settleAccountsVO) {
        ServiceSettleAccountsDO settleAccountsDO = new ServiceSettleAccountsDO(settleAccountsVO);
        requirementsDao.settleAccounts(settleAccountsDO);
        requirementsDao.updatesettleAccounts(settleAccountsVO.getRequirementsInfoId());
        return ResultBody.success();
    }

    @Override
    public ResultBody<ServiceSettleAccountsDTO> settleAccountsDetails(Integer requirementsInfoId, Integer userAccountId) {
        ServiceSettleAccountsDO settleAccountsDO = requirementsDao.settleAccountsDetails(requirementsInfoId, userAccountId);
        ServiceSettleAccountsDTO settleAccountsDTO = settleAccountsDO.buildServiceSettleAccountsDTO();
        return ResultBody.success(settleAccountsDTO);
    }

    @Override
    public ResultBody evaluate(ServiceEvaluateVO evaluateVO) {
        ServiceEvaluateDO serviceEvaluateDO = new ServiceEvaluateDO(evaluateVO);
        requirementsDao.evaluate(serviceEvaluateDO);
        requirementsDao.updateEvaluate(evaluateVO.getRequirementsInfoId());
        return ResultBody.success();
    }

    @Override
    public ResultBody<ServiceEvaluateDTO> evaluateDetails(Integer requirementsInfoId, Integer userAccountId) {
        ServiceEvaluateDO serviceEvaluateDO = requirementsDao.evaluateDetails(requirementsInfoId, userAccountId);
        ServiceEvaluateDTO serviceEvaluateDTO = serviceEvaluateDO.buildServiceEvaluateDTO();
        return ResultBody.success(serviceEvaluateDTO);
    }


    public PilotCertificationInteriorDTO feignInteriorDetailPilot(Integer userAccountId, HttpServletRequest request) {
        String token = request.getHeader("token");
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        headers.add("token", token);
        HttpEntity<String> entity = new HttpEntity<>(JSONObject.toJSONString(userAccountId), headers);
        ResponseEntity<PilotCertificationInteriorDTO> exchange1 = restTemplate.exchange(userApp + "/userapp/pilot/interiorDetailPilot?userAccountId=" + userAccountId, HttpMethod.GET, entity, PilotCertificationInteriorDTO.class);
        PilotCertificationInteriorDTO body = exchange1.getBody();
        return body;
    }

    public ResultBody releaseOrder(RequirementsInfoVO requirementsInfoVO, String token) {
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        headers.add("token", token);
        HttpEntity<String> entity = new HttpEntity<>(JSONObject.toJSONString(requirementsInfoVO), headers);
        ResponseEntity<Object> exchange = null;
        try {
            exchange = restTemplate.exchange(omsApp + "releaseOrder/publish", HttpMethod.POST, entity, Object.class);
        } catch (RestClientException e) {
            return ResultBody.error(ResultEnum.THE_THIRD_PARTY_INTERFACE_IS_BEING_UPDATED);
        }
        return ResultBody.success();
    }


    public List<IndustryTypeDTO> listIndustry() {
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        HttpEntity<String> entity = new HttpEntity<>(null, headers);
        ResponseEntity<List> exchange = restTemplate.exchange(pmsApp + "/pms/industry/listIndustry", HttpMethod.GET, entity, List.class);
        List<IndustryTypeDTO> body = (List<IndustryTypeDTO>) exchange.getBody();
        String s = JSON.toJSONString(body);
        List<IndustryTypeDTO> industryTypeDTOS = JSONObject.parseArray(s, IndustryTypeDTO.class);
        ArrayList<IndustryTypeDTO> list = new ArrayList<>();
        for (IndustryTypeDTO industryTypeDTO : industryTypeDTOS) {
            list.add(industryTypeDTO);
        }
        return list;
    }

    public String randomOrderCode() {
        SimpleDateFormat dmDate = new SimpleDateFormat("yyyyMMddHHmmss");
        String ranData = getRandom(6);
        Date date = new Date();
        String dateRan = dmDate.format(date);
        String xsCode = "R" + dateRan + ranData;
        if (xsCode.length() < 24) {
            xsCode = xsCode + 0;
        }
        return xsCode;
    }

    public String getRandom(int len) {
        Random r = new Random();
        StringBuilder rs = new StringBuilder();
        for (int i = 0; i < len; i++) {
            rs.append(r.nextInt(10));
        }
        return rs.toString();
    }


}
