package com.mmc.csf.infomation.vo;

import com.mmc.csf.release.model.group.Insert;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

import javax.validation.constraints.NotNull;
import java.math.BigDecimal;

/**
 * @Author small
 * @Date 2023/8/19 15:57
 * @Version 1.0
 */
@Data
@AllArgsConstructor
@NoArgsConstructor
@Builder
public class GetOrderNumberVO {

    @ApiModelProperty(value = "订单金额", example = "100", required = true)
    @NotNull(message = "订单金额", groups = {Insert.class})
    private BigDecimal orderAmount;

    @ApiModelProperty(value = "订单级别 todo:前端传英文,后台自己获取金额 订单级别(REGULAR_ORDER,RUSH_ORDER,TOP_ORDER)", example = "REGULAR_ORDER", required = true)
    @NotNull(message = "订单级别", groups = {Insert.class})
    private OrderLevelEnum orderLevelEnum;


    @ApiModelProperty(value = "云享金", example = "10", hidden = true)
    private BigDecimal cashAmount;

    @ApiModelProperty(value = "佣金", example = "10", hidden = true)
    private BigDecimal salaryAmount;

    @ApiModelProperty(value = "微信金额", example = "10", hidden = true)
    private BigDecimal weChatPay;

    @ApiModelProperty(value = "用户id", example = "10", hidden = true)
    private Integer userAccountId;
    @ApiModelProperty(value = "支付方式，云享金：1，佣金：2，微信支付：3", example = "1,2,3", required = true)
    private String paymentType;

    @ApiModelProperty(value = "订单方式 发布订单:1 ,抢单：2", example = "1", required = true)
    private Integer orderMode;


}
