import {
  BackEndLoginType,
  cooperationServiceBitmap,
  getSecondDistrictInfo,
  listCompanyInfoByCoopIdType
} from '@/api/interface/common'
import request from '../request'

export default class CommonAPI {
  // 用户登录
  static BackEndLogin: BackEndLoginType = (params) =>
    request.post('/userapp/auth/backEndLogin', params)

  // 地域
  static getSecondDistrictInfo: getSecondDistrictInfo = (params) =>
    request.get('/pms/webDevice/getSecondDistrictInfo', params)

  // 服务商网点数据
  static cooperationServiceBitmap: cooperationServiceBitmap = (params) =>
    request.get('/userapp/cooperation/service/bitmap', params)

  // 合作商家列表-根据合作标签id获取
  static listCompanyInfoByCoopId: listCompanyInfoByCoopIdType = (params) =>
    request.get('/userapp/cooperation/listCompanyInfoByCoopId', params)
}
