import {
  allCommentListType,
  appGambitListsType,
  attentionType,
  dynamicRecentNewsType,
  forumDetailType,
  forumListType,
  gambitAppRemoveType,
  gambitLikedType,
  getRemainingVotesType,
  likeOrCancelType,
  listGambitType,
  publishCommentType,
  publishForumType,
  replyListType,
  reviewLikesType,
  transPondType,
  userMessageType
} from '@/api/interface/forum'
import request from '@/api/request'

class ForumAPI {
  // 论坛列表
  static getForumList: forumListType = (data) => {
    return request.get('/release/dynamic/dynamicList', data)
  }

  // 论坛-评论-发表
  static publishComment: publishCommentType = (data) => {
    return request.post('/release/dynamic/comment', data)
  }

  // 论坛-发布
  static publishForum: publishForumType = (data) => {
    return request.post('/release/dynamic/publish', data)
  }

  //  论坛-点赞或取消点赞
  static likeOrCancel: likeOrCancelType = (data) => {
    return request.get('/release/dynamic/likeOrCancel', data)
  }

  //  论坛-详情
  static getForumDetail: forumDetailType = (data) => {
    return request.get('/release/dynamic/dynamicDetails', data)
  }

  //  话题-列表（小程序）
  static getAppGambitList: listGambitType = (data) =>
    request.post('/release/dynamic/appGambitList', data)

  //   话题-话题下的帖子
  static getAppGambitLists: appGambitListsType = (data) =>
    request.post('/release/gambit/appGambitLists', data)

  // 话题-评论/回复点赞,取消
  static reviewLikes: reviewLikesType = (data) => request.get('/release/dynamic/reviewLikes', data)

  //   话题-所有评论
  static getAllCommentList: allCommentListType = (data) =>
    request.post('/release/gambit/allCommentList', data)

  //   话题-评论下的回复
  static getReplyList: replyListType = (data) => request.post('/release/gambit/replyList', data)

  //   话题-单个用户信息
  static getUserMessage: userMessageType = (data) =>
    request.get('/release/gambit/userMessage', data)

  //   帖子-关注
  static attention: attentionType = (data) => request.get('/release/gambit/attention', data)

  // 话题-个人点赞过的帖子
  static getGambitLiked: gambitLikedType = (data) => request.post('/release/gambit/liked', data)

  //   话题-帖子删除
  static gambitAppRemove: gambitAppRemoveType = (data) =>
    request.get('/release/gambit/appRemove', data)

  // new-小程序-返回最新5条带动态的图片
  static dynamicRecentNews: dynamicRecentNewsType = (data) =>
    request.get('/release/dynamic/recentNews', data)

  //   帖子-转发数
  static transPond: transPondType = (data) => request.get('/release/gambit/transPond', data)

  // 查看剩余投票次数
  static getRemainingVotes: getRemainingVotesType = (data) =>
    request.get('/release/dynamic/getRemainingVotes', data)
}
export default ForumAPI
