import { InterFunction, InterItemFunction, InterListFunction } from '@/api/interface'

// 论坛列表
export type forumListType = InterItemFunction<
  {
    userId?: number
    gambitId?: number
    userAccountId?: number
    gambitName?: string
    needSort?: number
  },
  {
    id: number
    commentCount: number
    description: string
    likes: boolean
    likesCount: number
    transpond: number
    title: string
    mediaVO: { type: number; url: string }[]
    userAccountId: number
    userBaseInfo: {
      nickName: string
      userImg: string
    }
    forumGambitDTOList?: {
      /**
       * 话题参与讨论数量
       */
      discussionCount?: number
      /**
       * 话题封面
       */
      gambitCover?: string
      /**
       * 话题图标
       */
      gambitIcon?: string
      /**
       * 话题名称
       */
      gambitName?: string
      /**
       * 话题属性
       */
      gambitProperty?: number
      id: number
      /**
       * 贴子数
       */
      postCount?: number
    }[]
    status: number
    gambitName?: string[]
    dynamicPublishTime: string
    commentAndReplyVO: {
      commentAndReplyVO: null
      commentCount: null
      description: string
      dynamicPublishTime: string
      id: number
      lat: null
      likes: null
      likesCount: null
      location: null
      lon: null
      mediaVO: null
      userAccountId: number
      userBaseInfo: {
        nickName: string
        userImg: string
      }
    }[]
    forumReviewVO?: {
      /**
       * 评论内容
       */
      content?: string
      /**
       * 创建时间
       */
      createTime?: string
      /**
       * 动态id
       */
      dynamicId?: number
      /**
       * id
       */
      id: number
      /**
       * 评论点赞数
       */
      likeCount?: number
      /**
       * pid
       */
      pid?: number
      /**
       * 回复id
       */
      reviewId?: number
      /**
       * 更新时间
       */
      updateTime?: string
      /**
       * 用户id
       */
      userAccountId?: number
      status?: number
      userAccountVO: {
        nickName: string
        userImg: string
        id: number
      }
    }
  }[]
>
// 发表评论
export type publishCommentType = InterFunction<
  {
    content: string
    dynamicId: number
    rootPath?: string
    /**
     * pid(注意:单纯评论就为0,有回复就上级id)
     */
    pid?: number
    /**
     * 评论id(注意:单纯评论就为0 ,有回复就评论id)
     */
    reviewId?: number
  },
  any
>
// 论坛发布
export type publishForumType = InterFunction<
  {
    description?: string
    title?: string
    mediaVO?: { type: number; url: string }[]
    location?: string
    lat?: number
    lon?: number
    /**
     * 话题封面
     */
    gambitCover?: string
    /**
     * 话题图标
     */
    gambitIcon?: string
    /**
     * 话题名称
     */
    gambitName?: string[]
  },
  null
>
// 论坛点赞或取消点赞
export type likeOrCancelType = InterFunction<{ dynamicId: number; userId?: number }, null>
// 论坛详情
type detailType = {
  id: number
  commentAndReplyVO: detailType[]
  description: string
  likes: boolean
  likesCount: number
  title: string
  commentCount: number
  dynamicPublishTime: string
  mediaVO: { type: number; url: string }[]
  userBaseInfo: {
    nickName: string
    userImg: string
  }
  userAccountId: number
  location: string
  gambitName?: string[]
  forumGambitDTOList?: {
    /**
     * 话题参与讨论数量
     */
    discussionCount?: number
    /**
     * 话题封面
     */
    gambitCover?: string
    /**
     * 话题图标
     */
    gambitIcon?: string
    /**
     * 话题名称
     */
    gambitName?: string
    /**
     * 话题属性
     */
    gambitProperty?: number
    id: number
    /**
     * 贴子数
     */
    postCount?: number
  }[]
}
export type forumDetailType = InterFunction<
  { dynamicId: number; userAccountId: number },
  detailType
>
// 话题列表
export type listGambitType = InterListFunction<
  {
    gambitId?: number
    /**
     * 话题名称
     */
    gambitName?: string
    /**
     * 话题属性 1普通 2热门 3推荐
     */
    gambitProperty?: number
  },
  {
    /**
     * 话题参与讨论数量
     */
    discussionCount?: number
    /**
     * 话题封面
     */
    gambitCover?: string
    /**
     * 话题图标
     */
    gambitIcon?: string
    /**
     * 话题名称
     */
    gambitName: string
    /**
     * 话题属性
     */
    gambitProperty: number
    id: number
    /**
     * 贴子数
     */
    postCount?: number
  }
>
// 话题-话题下的帖子
export type appGambitListsType = InterListFunction<
  { gambitId?: number },
  {
    /**
     * 评论数
     */
    commentsCount?: number
    /**
     * 创建时间
     */
    createTime?: string
    /**
     * 描述
     */
    description?: string
    /**
     * 话题
     */
    forumGambitDOList?: {
      /**
       * 话题参与讨论数量
       */
      discussionCount?: number
      /**
       * 话题封面
       */
      gambitCover?: string
      /**
       * 话题图标
       */
      gambitIcon?: string
      /**
       * 话题名称
       */
      gambitName?: string
      /**
       * 话题属性
       */
      gambitProperty?: number
      id?: number
      /**
       * 贴子数
       */
      postCount?: number
    }[]
    /**
     * 图片
     */
    forumResourceDOList?: {
      createTime?: Date
      dynamicId?: number
      resourceUrl?: string
      type?: number
      updateTime?: Date
    }[]
    forumReviewDO?: {
      /**
       * 评论内容
       */
      content?: string
      /**
       * 创建时间
       */
      createTime?: string
      /**
       * 动态id
       */
      dynamicId?: number
      /**
       * id
       */
      id?: number
      /**
       * 评论点赞数
       */
      likeCount?: number
      /**
       * pid
       */
      pid?: number
      /**
       * 回复id
       */
      reviewId?: number
      /**
       * 更新时间
       */
      updateTime?: string
      /**
       * 用户id
       */
      userAccountId?: number
    }[]
    /**
     * id
     */
    id?: number
    /**
     * 点赞数
     */
    likesCount?: number
    /**
     * 转发数
     */
    transpond?: number
    /**
     * 发布者用户
     */
    userAccountId?: number
  }
>
// 话题-评论/回复点赞,取消
export type reviewLikesType = InterFunction<
  {
    /**
     * id
     */
    id: number
    /**
     * status
     */
    status: boolean
  },
  any
>
// 话题-所有评论
export type allCommentListType = InterListFunction<
  { dynamicId: number; userAccountId: number },
  {
    /**
     * 评论内容
     */
    content: string
    /**
     * 创建时间
     */
    createTime?: string
    /**
     * 动态id
     */
    dynamicId: number
    /**
     * id
     */
    id: number
    /**
     * 评论点赞数
     */
    likeCount?: number
    /**
     * pid
     */
    pid?: number
    /**
     * 回复id
     */
    reviewId?: number
    /**
     * 更新时间
     */
    updateTime?: string
    /**
     * 用户id
     */
    userAccountId?: number
    status: number
    replyCount: number
    userAccountVO: {
      userImg: string
      userName: string
      nickName: string
      id: number
    }
  }
>
// 话题-评论下的回复
export type replyListType = InterListFunction<
  {
    /**
     * 动态id
     */
    dynamicId: number
    /**
     * 评论id
     */
    id: number
  },
  {
    /**
     * 评论内容
     */
    content?: string
    /**
     * 创建时间
     */
    createTime?: string
    /**
     * 动态id
     */
    dynamicId?: number
    /**
     * id
     */
    id: number
    /**
     * 评论点赞数
     */
    likeCount?: number
    /**
     * pid
     */
    pid?: number
    /**
     * 回复id
     */
    reviewId?: number
    /**
     * 更新时间
     */
    updateTime?: string
    /**
     * 用户id
     */
    userAccountId?: number
    status: number
    userAccountVO: {
      userImg: string
      userName: string
      nickName: string
      id: number
    }
  }
>
// 话题-个人主页用户信息
export type userMessageType = InterFunction<
  {
    /**
     * userAccountId
     */
    userAccountId: number
  },
  {
    /**
     * 关注数量
     */
    attentionCount?: number
    /**
     * 创建时间
     */
    createTime?: string
    /**
     * 粉丝数量
     */
    fansCount?: number
    /**
     * id
     */
    id: number
    /**
     * 获赞数量
     */
    likeCount?: number
    /**
     * 修改时间
     */
    updateTime?: string
    /**
     * 用户id
     */
    userAccountId: number
    status: boolean
    userAccountMessageVo: {
      /**
       * 能力
       */
      abilityName?: string[]
      /**
       * 年龄
       */
      birthday?: any
      pilotId?: number
      /**
       * 性别
       */
      sex?: number
      /**
       * 用户id
       */
      userAccountId?: number
      /**
       * 工作年限
       */
      yearsOfWorking?: number
    }
    pilotStatus: boolean
    pilotId: number
  }
>
// 关注
export type attentionType = InterFunction<
  {
    /**
     * 关注状态 true
     */
    status: boolean
    /**
     * 被关注的用户
     */
    userAccountId: number
  },
  any
>
// 话题-个人点赞过的帖子
export type gambitLikedType = InterListFunction<{ userAccountId: number }, any>
// 话题-帖子删除
export type gambitAppRemoveType = InterFunction<{ dynamicId: number }, any>
// new-小程序-返回最新5条带动态的图片
export type dynamicRecentNewsType = InterFunction<
  { userAccountId?: number },
  {
    checkStatus: number
    commentsCount: number
    description: string
    forumGambitDOList: Array<{
      discussionCount: number
      gambitCover: string
      gambitIcon: string
      gambitName: string
      gambitProperty: string
      id: number
      postCount: number
    }>
    forumResourceDOList: Array<{
      createTime: string
      dynamicId: number
      resourceUrl: string
      type: number
      updateTime: string
    }>
    id: number
    lat: number
    likesCount: number
    location: string
    lon: number
    rootPath: string
    userAccountId: number
    userAccountVO: {
      accountNo: string
      accountStatus: number
      accountType: number
      briefIntroduction: string
      companyAuthStatus: number
      companyName: string
      cooperationTagId: number
      coverPicture: string
      createTime: string
      deleted: number
      email: string
      id: number
      nickName: string
      phoneNum: string
      portType: number
      region: string
      remark: string
      source: number
      tagName: string
      uid: string
      userImg: string
      userName: string
      userSex: number
    }
    version: number
  }[]
>
// 帖子-转发数
export type transPondType = InterFunction<{ dynamicId: number }, any>
// 查看剩余投票次数
export type getRemainingVotesType = InterFunction<{ gambitId: number }, number>
