import React from 'react';
import { Button } from 'antd';
import { useRouter } from 'next/router';
import styled from 'styled-components';
import { InterListType } from '@/api/interface';
import { ListTenderInfoType } from '@/api/interface/home';

// 详情类型
type DetailType = InterListType<ListTenderInfoType>[0];
const NewsTenderItem: React.FC<{ detail: DetailType; full?: Boolean }> = ({
  detail,
  full = false,
}) => {
  // 路由钩子
  const router = useRouter();
  // 点击详情
  const handleDetail = async () => {
    await router.push(`/news/detail/${detail?.id}?type=2`);
  };
  return (
    <NewsTenderWrap
      onClick={handleDetail}
      style={{ width: full ? '100%' : '86%' }}
    >
      <div className="title">
        <div className="text">{detail?.tenderTitle}</div>
        <Button className="action" type="primary">
          联系合作
        </Button>
      </div>
      <div className="tags">
        <div className="tag">{detail?.tenderPrice}万元</div>
        <div className="tag">{detail?.createTime}</div>
      </div>
    </NewsTenderWrap>
  );
};

export default NewsTenderItem;
// 样式
const NewsTenderWrap = styled.div`
  position: relative;
  width: 86%;
  //width: 100%;
  box-sizing: border-box;
  margin: 0 auto 0.83rem;
  min-height: 4.8rem;
  background: #ffffff;
  box-shadow: 0 0.17rem 1rem 0 rgba(102, 120, 192, 0.11);
  border-radius: 0.5rem;
  display: flex;
  align-items: flex-start;
  justify-content: center;
  flex-direction: column;
  padding: 0.25rem 0.83rem 0.5rem 0.83rem;
  cursor: pointer;
  .title {
    position: relative;
    width: 100%;
    display: flex;
    align-items: center;
    justify-content: space-between;
    .text {
      font-size: 16px;
      font-weight: bold;
      color: #333333;
      margin-bottom: 0.5rem;
      &:hover {
        color: #ff552d;
      }
    }
  }
  .tags {
    position: relative;
    width: 100%;
    display: flex;
    align-items: center;
    justify-content: flex-start;
    .tag:not(:last-child) {
      margin-right: 0.5rem;
    }
    .tag {
      color: #ff552d;
      background: #fff5f4;
      box-sizing: border-box;
      padding: 0 0.5rem;
    }
  }
`;
