import React, { useEffect, useState } from 'react';
import { FieldTimeOutlined, VerticalAlignTopOutlined } from '@ant-design/icons';
import { Carousel } from 'antd';
import styled from 'styled-components';
import { HomeAPI } from '@/api';
import { InterListType } from '@/api/interface';
import { ListNewsType } from '@/api/interface/home';

// 新闻列表类型
type ListType = InterListType<ListNewsType>;

const NewsSwiperView = () => {
  // 新闻列表
  const [newsList, setNewsList] = useState<ListType>([]);
  // 热点资讯列表
  const getListNews = async () => {
    const res = await HomeAPI.getListNews({
      pageNo: 1,
      pageSize: 10,
      isHot: 1,
    });
    if (res && res.code === '200') {
      setNewsList(res.result.list || []);
    }
  };
  // 组件挂载
  useEffect(() => {
    getListNews().then();
  }, []);
  return (
    <NewsSwiperWrap>
      <Carousel autoplay={true}>
        {newsList?.map((i, j) => (
          <div className="swiper-view" key={j}>
            <div className="swiper-item">
              <img
                className="item-image"
                src={i?.surfaceImg}
                alt={i.newsTitle}
              />
              <div className="item-content">
                <div className="content-head">
                  <div className="top">
                    <VerticalAlignTopOutlined />
                    <span className="text">置顶</span>
                  </div>
                  <div className="time">
                    <FieldTimeOutlined />
                    <span className="text">{i?.createTime}</span>
                  </div>
                </div>
                <div className="content-title">{i?.newsTitle}</div>
                <div className="content-desc two-line-ellipsis">
                  {i?.newsContents?.match(/(?<=>)[^<>]+(?=<)/g)}
                </div>
              </div>
            </div>
          </div>
        ))}
      </Carousel>
    </NewsSwiperWrap>
  );
};

export default NewsSwiperView;
// 样式
const NewsSwiperWrap = styled.div`
  position: relative;
  width: 86%;
  //width: 100%;
  box-sizing: border-box;
  margin: 0 auto;
  .swiper-view {
    position: relative;
    width: 100%;
    height: 19rem;
    box-sizing: border-box;
    //background: lightblue;
    .swiper-item {
      position: relative;
      width: 100%;
      height: 17rem;
      background: #ffffff;
      border-radius: 0.83rem;
      display: flex;
      align-items: center;
      justify-content: flex-start;
      padding: 0 1.58rem;
      .item-image {
        width: 28rem;
        height: 14rem;
        border-radius: 0.42rem;
        object-fit: cover;
        margin-right: 2rem;
      }
      .item-content {
        position: relative;
        width: calc(100% - 28rem - 2rem);
        box-sizing: border-box;
        .content-head {
          position: relative;
          width: 100%;
          display: flex;
          align-items: center;
          justify-content: space-between;
          font-size: 13px;
          font-weight: 500;
          margin-bottom: 1rem;
          .top {
            color: #ff5702;
          }
          .time {
            color: #999999;
          }
          .text {
            margin-left: 0.25rem;
          }
        }
        .content-title {
          font-size: 16px;
          font-weight: 550;
          color: #333333;
          margin-bottom: 1rem;
        }
      }
    }
  }
  .slick-dots {
    .slick-active {
      button {
        background: #ff5702 !important;
      }
    }
    button {
      background: #999 !important;
    }
  }
`;
