import React from 'react';
import { RightOutlined } from '@ant-design/icons';
import { Rate } from 'antd';
import styled from 'styled-components';
import { InterListType } from '@/api/interface';
import { AppListPilotType } from '@/api/interface/home';

// 详情类型
type DetailType = InterListType<AppListPilotType>[0];

const FlyerListItem: React.FC<{ detail: DetailType }> = ({ detail }) => {
  return (
    <FlyerListItemWrap>
      <div className="item-arrow">
        <RightOutlined style={{ fontSize: 10, color: '#A0A0A0' }} />
      </div>
      <div className="item-head flex-start">
        <img
          className="head-image"
          src={detail?.userImg}
          alt={detail?.userName}
        />
        <div className="head-content">
          <div className="content-title flex-start">
            <div className="title-name">{detail?.userName}</div>
            <Rate
              allowHalf
              disabled
              defaultValue={4}
              style={{ fontSize: '12px', color: '#FE562F' }}
            />
          </div>
          <div className="content-text flex-start">
            <div className="text-item">{detail?.residentCity}</div>
            <div className="text-item">{detail?.age}岁</div>
            <div className="text-item">{detail?.yearsOfWorking}年经验</div>
          </div>
          <div className="content-tag flex-start">
            {detail?.pilotAbility?.map((n, m) => (
              <div className="tag-item" key={m}>
                {n.abilityName}
              </div>
            ))}
          </div>
        </div>
      </div>
      <div className="item-foot flex-start">
        <div className="foot-state">空闲</div>
        <div
          className="foot-text text-ellipsis"
          title={detail?.individualResume}
        >
          {detail?.individualResume}
        </div>
      </div>
    </FlyerListItemWrap>
  );
};

export default FlyerListItem;
// 样式
const FlyerListItemWrap = styled.div`
  position: relative;
  box-sizing: border-box;
  width: calc((100% - (0.85rem * 3)) / 4);
  //width: 14.13rem;
  min-height: 5.54rem;
  background: #ffffff;
  border-radius: 0.25rem;
  border: 0.04rem solid #e3e3e3;
  margin: 0 0.85rem 0.85rem 0;
  padding: 0.83rem 0 0 0.83rem;
  &:nth-child(4n) {
    margin-right: 0;
  }
  &:active,
  &:hover {
    filter: brightness(0.95);
  }
  .item-arrow {
    position: absolute;
    top: 0.67rem;
    right: 0.67rem;
  }
  .item-head {
    flex-wrap: nowrap;
    .head-image {
      width: 3rem;
      height: 3rem;
      border-radius: 4px;
      margin-right: 0.38rem;
    }
    .head-content {
      position: relative;
      width: calc(100% - 4rem);
      .content-title {
        align-items: baseline;
        margin-bottom: 0.2rem;
        .title-name {
          font-size: 14px;
          font-weight: 550;
          color: #333333;
          margin-right: 0.2rem;
        }
      }
      .content-text {
        margin-bottom: 0.2rem;
        .text-item {
          font-size: 12px;
          font-weight: 400;
          margin-right: 0.5rem;
          &:last-child {
            margin-right: 0;
          }
        }
      }
      .content-tag {
        flex-wrap: wrap;
        margin-bottom: 0.33rem;
        min-height: 0.79rem;
        .tag-item {
          min-width: 2.42rem;
          height: 0.79rem;
          border-radius: 0.17rem;
          border: 0.04rem solid #fe562f;
          text-align: center;
          line-height: 0.79rem;
          font-size: 0.5rem;
          font-weight: 400;
          color: #fe562f;
          margin-right: 0.33rem;
        }
      }
      &::after {
        position: absolute;
        content: '';
        bottom: 0;
        left: 0;
        width: 100%;
        //width: 8.21rem;
        height: 0.02rem;
        background: #dedede;
      }
    }
  }
  .item-foot {
    min-height: 1.42rem;
    box-sizing: border-box;
    padding: 0.33rem 0;
    .foot-state {
      position: relative;
      width: 3rem;
      text-align: center;
      margin-right: 0.33rem;
      font-size: 12px;
      color: #44d979;
      &::after {
        position: absolute;
        content: '';
        top: calc((100% - 0.25rem) / 2);
        left: 0;
        width: 0.25rem;
        height: 0.25rem;
        background: #44d979;
        border-radius: 50%;
      }
    }
    .foot-text {
      width: calc(100% - 3.33rem);
      font-size: 12px;
      font-weight: 400;
      color: #999999;
    }
  }
`;
