import {
  GetCompanyInfoById,
  GetCompanyInspectionById,
  GetIndustryListPagesType,
  GetListAPPCompanyInspectionPageType,
  IndustryListPages,
  ListAPPCompanyInspectionPage,
  ListInspectionPriceUnit,
} from '@/api/interface/service';
import request from '@/api/request';

export class ServiceAPI {
  // 一级行业列表
  static getIndustryListPages: GetIndustryListPagesType = (params) =>
    request.post('/pms/industry/listPages', params);

  // 单位服务列表-小程序展示
  static getListAPPCompanyInspectionPage: GetListAPPCompanyInspectionPageType =
    (params) =>
      request.post(
        '/pms/company-inspection/listAPPCompanyInspectionPage',
        params,
      );

  // 价格单位列表
  static listInspectionPriceUnit: ListInspectionPriceUnit = (params) =>
    request.get('/pms/company-inspection/listInspectionPriceUnit', params);

  // 单位服务详情
  static getCompanyInspectionById: GetCompanyInspectionById = (params) =>
    request.get('/pms/company-inspection/getCompanyInspectionById', { params });

  // 单位查询
  static getCompanyInfoById: GetCompanyInfoById = (params) =>
    request.get('/userapp/company/getCompanyInfoById', { params });

  // 单位服务列表-小程序展示
  static listAPPCompanyInspectionPage: ListAPPCompanyInspectionPage = (
    params,
  ) =>
    request.post(
      '/pms/company-inspection/listAPPCompanyInspectionPage',
      params,
    );

  // 一级行业列表
  static IndustryListPages: IndustryListPages = (params) =>
    request.post('/pms/industry/listPages', params);
}
