import React from 'react';
import { ShopOutlined, UnorderedListOutlined } from '@ant-design/icons';
import { Menu, MenuProps } from 'antd';
import styled from 'styled-components';
import BreadcrumbView from '@/components/breadcrumb';
import LayoutView from '@/components/layout';
import MallOrderListTable from '@/pages/order/comp/mallOrderLsit/_index';

type MenuItem = Required<MenuProps>['items'];

const OrderListView = () => {
  // 菜单栏点击事件
  const handleMenuClick = (e: { key: string; keyPath: string[] }) => {
    console.log(e);
  };
  // 菜单栏数据
  const menuList: MenuItem = [
    {
      key: '1',
      label: '全部订单',
      icon: <UnorderedListOutlined />,
      children: [
        {
          key: '11',
          label: '商城订单',
          icon: <ShopOutlined />,
        },
      ],
    },
  ];
  return (
    <LayoutView>
      <OrderListWrap>
        <BreadcrumbView />
        <div className="flex w-full items-start justify-start pb-8 pt-2">
          <div className="select">
            <Menu
              mode="inline"
              items={menuList}
              defaultOpenKeys={['1']}
              defaultSelectedKeys={['11']}
              onClick={handleMenuClick}
            />
          </div>
          <div className="list">
            <MallOrderListTable />
          </div>
        </div>
      </OrderListWrap>
    </LayoutView>
  );
};

export default OrderListView;
// 样式
const OrderListWrap = styled.div`
  position: relative;
  max-width: 1190px;
  box-sizing: border-box;
  padding: 2rem 0 0 0;
  margin: 0 auto;
  .select {
    position: relative;
    width: 15%;
  }
  .list {
    position: relative;
    width: 85%;
  }
`;
