import React, { useEffect, useState } from 'react';
import { Button } from 'antd';
import styled from 'styled-components';
import { HomeAPI } from '@/api';
import { InterListType } from '@/api/interface';
import { ListBrandInfoType } from '@/api/interface/home';

// 列表类型
type ListType = InterListType<ListBrandInfoType>;

const TabView03 = () => {
  // 列表数据
  const [tabList, setTabList] = useState<ListType>([]);
  // 获取云享商城分类
  const getListBrandInfo = async () => {
    const res = await HomeAPI.getListBrandInfo({
      pageNo: 1,
      pageSize: 999,
    });
    if (res && res.code === '200') {
      setTabList(res.result?.list?.filter((i) => i.modeInfoList?.length));
      // console.log('获取云享商城分类 --->', res);
    }
  };
  // 组件挂载
  useEffect(() => {
    getListBrandInfo().then();
  }, []);
  return (
    <TabViewWrap className="animate__animated animate__fast animate__fadeIn">
      {tabList.map((i, j) => (
        <div key={j}>
          <div className={'tab-little flex-start'}>
            <div className="title-name">{i.brandName}</div>
          </div>
          <div className="tab-list flex-start">
            {i.modeInfoList?.map((n, m) => (
              <Button type={'link'} key={m} className="list-item">
                {n.modeName}
              </Button>
            ))}
          </div>
        </div>
      ))}
    </TabViewWrap>
  );
};
// 样式
const TabViewWrap = styled.div`
  position: relative;
  width: 100%;
  height: 100%;
  box-sizing: border-box;
  padding: 0.79rem 1.58rem;
  //background: lightyellow;
  .tab-little {
    position: relative;
    width: 100%;
    box-sizing: border-box;
    padding-bottom: 0.68rem;
    border-bottom: 0.02rem solid #ededed;
    margin-bottom: 0.5rem;
    .title-image {
      width: 1.68rem;
      height: 1.68rem;
      margin-right: 0.5rem;
    }
    .title-name {
      font-size: 0.75rem;
      font-weight: 550;
      color: #333333;
    }
  }
  .tab-list {
    position: relative;
    width: 100%;
    flex-wrap: wrap;
    margin-bottom: 1rem;
    transform: translateX(-10px);
    .list-item {
      color: #666666;
      font-weight: 500;
    }
  }
`;
export default TabView03;
