import React, { useEffect, useState } from 'react';
import { Button } from 'antd';
import { useRouter } from 'next/router';
import { useDispatch } from 'react-redux';
import styled from 'styled-components';
import { HomeAPI } from '@/api';
import { InterListType } from '@/api/interface';
import { IndustryListPagesType } from '@/api/interface/home';
import { setGlobalData } from '@/store/module/globalData';

// 列表类型
type ListType = InterListType<IndustryListPagesType>;

const TabView02 = () => {
  // 导航钩子
  const router = useRouter();
  // store
  const dispatch = useDispatch();
  // 列表数据
  const [tabList, setTabList] = useState<ListType>([]);
  // 获取分类列表
  const getIndustryListPages = async () => {
    const res = await HomeAPI.IndustryListPages({
      pageNo: 1,
      pageSize: 9999,
    });
    if (res && res.code === '200') {
      setTabList(res.result?.list?.filter((i) => i.inspectionDTOS?.length));
      // console.log('获取分类列表 --->', res.result);
    }
  };
  // 跳转一级分类详情
  const handleMain = (i: ListType[0]) => {
    dispatch(
      setGlobalData({
        loadingSpinnerVisible: true,
      }),
    );
    router.push(`/service/${i?.id}`).then();
  };
  // 跳转二级分类详情
  const handleSecond = (
    i: ListType[0],
    n: ListType[0]['inspectionDTOS'][0],
  ) => {
    dispatch(
      setGlobalData({
        loadingSpinnerVisible: true,
      }),
    );
    router.push(`/service/${i?.id}/${n?.id}`).then();
  };
  // 组件挂载
  useEffect(() => {
    getIndustryListPages().then();
  }, []);
  return (
    <TabViewWrap className="animate__animated animate__fast animate__fadeIn">
      {tabList.map((i, j) => (
        <div key={j}>
          <div className={'tab-little flex-start'}>
            {!!i.typeImg && (
              <img src={i.typeImg} alt={i.typeName} className="title-image" />
            )}
            <Button
              type={'link'}
              className="title-name"
              onClick={() => handleMain(i)}
            >
              {i.typeName}
            </Button>
          </div>
          <div className="tab-list flex-start">
            {i.inspectionDTOS?.map((n, m) => (
              <Button
                type={'link'}
                key={m}
                className="list-item"
                onClick={() => handleSecond(i, n)}
              >
                {n.inspectionName}
              </Button>
            ))}
          </div>
        </div>
      ))}
    </TabViewWrap>
  );
};
// 样式
const TabViewWrap = styled.div`
  position: relative;
  width: 100%;
  box-sizing: border-box;
  padding: 0.79rem 1.58rem;
  //background: lightyellow;
  .tab-little {
    position: relative;
    width: 100%;
    box-sizing: border-box;
    padding-bottom: 0.68rem;
    border-bottom: 0.02rem solid #ededed;
    margin-bottom: 0.5rem;
    .title-image {
      width: 1.68rem;
      height: 1.68rem;
    }
    .title-name {
      font-size: 0.75rem;
      font-weight: 550;
      color: #333333;
    }
  }
  .tab-list {
    position: relative;
    width: 100%;
    flex-wrap: wrap;
    margin-bottom: 1rem;
    transform: translateX(-10px);
    .list-item {
      color: #666666;
      font-weight: 500;
    }
  }
`;
export default TabView02;
