import React, { useEffect, useState } from 'react';
import { Empty, Segmented } from 'antd';
import styled from 'styled-components';
import { InterDataType, InterListType, InterReqType } from '@/api/interface';
import {
  BrandStoreListType,
  ListCompanyInfoByCoopIdType,
} from '@/api/interface/mall';
import { MallAPI } from '@/api/modules/mall';
import LayoutView from '@/components/layout';
import ProductListView from '@/components/productList';
import StoreProductItem from '@/pages/store/product/comp/_storeProductItem';

// 列表类型
type ListType = InterListType<ListCompanyInfoByCoopIdType>;
// 请求类型
type ReqType = InterReqType<ListCompanyInfoByCoopIdType>;
// 商品列表
type StoreType = InterDataType<BrandStoreListType>;

// 任务列表筛选
const actionList = [
  { label: '综合顺序', value: 0, data: {} },
  { label: '销量优先', value: 1, data: {} },
  { label: '好评优先', value: 2, data: {} },
];
const StoreProductListPage = () => {
  // 分页数据
  const [pagination, setPagination] = useState({
    pageNo: 1,
    pageSize: 10,
    totalCount: 0,
    totalPage: 0,
  });
  // 商家列表
  const [companyList, setCompanyList] =
    useState<
      Array<ListType[0] & { mallGoodsVOList: StoreType[0]['mallGoodsVOList'] }>
    >();
  // 获取商家列表
  const getListCompanyInfoByCoopId = async (data?: ReqType) => {
    const res = await MallAPI.listCompanyInfoByCoopId({
      coopId: 1,
      lat: 30,
      lon: 120,
      pageNo: pagination.pageNo,
      pageSize: pagination.pageSize,
      ...data,
    });
    if (res && res.code === '200') {
      const { list, pageNo, totalPage, totalCount } = res.result;
      setPagination({
        ...pagination,
        pageNo,
        totalPage,
        totalCount,
      });
      // 获取所有店铺的id
      const companyIdList = list?.map((i) => i.backUserAccountId) || [];
      // const companyList = [57]
      // 如果没有id则不请求
      if (companyIdList.length <= 0) return;
      // 获取店铺商品列表
      const productList = await MallAPI.brandStoreList(companyIdList);
      // 将商品列表添加到品牌列表中
      const brandList = list?.map((i) => ({
        ...i,
        mallGoodsVOList:
          productList?.result?.find(
            (n) => n.userAccountId === i.backUserAccountId,
          )?.mallGoodsVOList || [],
      }));
      setCompanyList(brandList || []);
      // // 将科比特提前到第一个
      // const kbt = companyBrandList.value?.filter((i) => i.companyName.includes('科比特'))
      // const other = companyBrandList.value?.filter((i) => !i.companyName.includes('科比特'))
      // // 合并数据
      // companyBrandList.value = [...kbt, ...other]
    }
  };
  // 翻页事件
  const handlePageChange = async (pageNo: number, pageSize: number) => {
    await getListCompanyInfoByCoopId({ pageNo, pageSize });
  };
  // 组件挂载
  useEffect(() => {
    getListCompanyInfoByCoopId().then();
  }, []);
  return (
    <LayoutView contentTitle={'全部品牌'}>
      <StoreProductListWrap>
        <div className="tab">
          <Segmented
            options={actionList?.map((i) => i?.label)}
            size="large"
            defaultValue={'附近'}
            // onChange={handleSelectAction}
          />
        </div>
        <ProductListView pagination={pagination} onChange={handlePageChange}>
          {companyList?.length ? (
            companyList?.map((i, j) => <StoreProductItem key={j} detail={i} />)
          ) : (
            <div className="list-empty flex-center">
              <Empty />
            </div>
          )}
        </ProductListView>
      </StoreProductListWrap>
    </LayoutView>
  );
};

export default StoreProductListPage;
// 样式
const StoreProductListWrap = styled.div`
  position: relative;
  max-width: 1190px;
  box-sizing: border-box;
  padding: 1rem 0 0 0;
  margin: 0 auto;
  .tab {
    position: relative;
    width: 100%;
    display: flex;
    justify-content: flex-end;
    margin-bottom: 1rem;
  }
`;
