import React, { useEffect, useState } from 'react';
import { App } from 'antd';
import { CommonAPI } from '@/api';

const QrcodeView: React.FC<{
  path?: string;
  scene?: string;
}> = ({ path = 'pages/welcome/index', scene = 'type=share' }) => {
  // 消息钩子
  const { message } = App.useApp();
  // 二维码的地址
  const [qrCodeData, setQrCodeData] = useState<string>();
  // 获取二维码
  const getQrcodeLogin = async () => {
    // 获取二维码
    const res = await CommonAPI.getAppletQRCode({
      page: path || 'pages/welcome/index',
      scene: scene || 'type=share',
    });
    if (res && res.code === '200') {
      if (!res.result) {
        message.warning('获取登录二维码失败');
        return;
      }
      // 设置当前登录的二维码
      setQrCodeData(`data:image/png;base64,${res.result}`);
    }
  };
  // 组件挂载
  useEffect(() => {
    if (!path) return;
    getQrcodeLogin().then();
  }, [path]);
  return (
    <img
      className="animate__animated animate__faster animate__fadeIn h-full w-full"
      src={qrCodeData}
      alt="云享飞小程序"
    />
  );
};

export default QrcodeView;
