import React, { useEffect, useState } from 'react';
import { Button, Modal } from 'antd';
import { useRouter } from 'next/router';
import { useDispatch, useSelector } from 'react-redux';
import styled from 'styled-components';
import { HomeAPI } from '@/api';
import { InterDataType } from '@/api/interface';
import { ListBannerImgType } from '@/api/interface/home';
import { RootState } from '@/store';
import { GlobalDataState, setGlobalData } from '@/store/module/globalData';

type AgreeType = InterDataType<ListBannerImgType>;

const AgreeModalView: React.FC<{
  open: boolean;
}> = ({ open }) => {
  // store
  const dispatch = useDispatch();
  // 路由钩子
  const router = useRouter();
  // system
  const globalData = useSelector(
    (state: RootState) => state.globalData,
  ) as GlobalDataState;
  // 协议内容
  const [agreementData, setAgreementData] = useState<AgreeType>();
  // 关闭弹窗
  const handleClose = () => {
    dispatch(setGlobalData({ agreeModalVisible: false }));
    // 如果需要返回
    if (globalData.toastModalBack) router.back();
  };
  // 获取协议
  const getAgreementData = async () => {
    const res = await HomeAPI.listBannerImg({
      moduleCode: 'SHAREFLY_ABOUT',
    });
    if (res && res.code === '200') {
      setAgreementData(res.result);
    }
  };
  useEffect(() => {
    if (!open) return;
    getAgreementData().then();
  }, [open]);
  return (
    <Modal
      open={open}
      title={
        globalData?.agreeModalType === 1 ? '云享飞隐私协议' : '云享飞用户协议'
      }
      onCancel={handleClose}
      width={720}
      footer={null}
    >
      <AgreeModalWrap>
        <div className={'content'}>
          {agreementData?.[globalData?.agreeModalType]?.textContent && (
            <div
              className="w-full"
              dangerouslySetInnerHTML={{
                __html:
                  agreementData?.[globalData?.agreeModalType]?.textContent,
              }}
            />
          )}
        </div>
        <Button type="primary" onClick={handleClose}>
          同意并继续
        </Button>
      </AgreeModalWrap>
    </Modal>
  );
};

export default AgreeModalView;
// 样式
const AgreeModalWrap = styled.div`
  position: relative;
  width: 100%;
  height: 26.8rem;
  display: flex;
  justify-content: flex-start;
  align-items: center;
  flex-direction: column;
  box-sizing: border-box;
  .content {
    position: relative;
    width: 100%;
    height: 24.8rem;
    margin-bottom: 1rem;
    overflow-y: scroll;
    box-sizing: border-box;
    &::-webkit-scrollbar {
      background-color: transparent;
      -webkit-border-radius: 2em;
      -moz-border-radius: 2em;
      border-radius: 2em;
      width: 7px;
      height: 7px;
    }

    &::-webkit-scrollbar-thumb {
      background: #d9d9d9;
      -webkit-border-radius: 2em;
      -moz-border-radius: 2em;
      border-radius: 2em;
    }
  }
`;
