import request, { Response } from '~/api/request';

export interface GetLeaseGoodsDetailParams {
  goodsId: number;
  type: 1 | 0; //租赁：1 销售商品：0
}

export interface GetLeaseGoodsDetailResp {
  id: number;
  images: Image[];
  goodsVideo?: any;
  goodsVideoId?: any;
  goodsName: string;
  goodsNo: string;
  goodsDetail: GoodsDetail;
  directoryId: number;
  categoryByOne: number;
  categoryByTwo?: any;
  tag?: any;
  shelfStatus: number;
  goodsSpec: GoodsSpec[];
  otherService: OtherService[];
  price?: any;
}

export interface OtherService {
  id: number;
  saleServiceId: number;
  serviceName: string;
}

export interface GoodsSpec {
  id: number;
  goodsSpecName: string;
  categoryId: number;
  typeName: string;
  skuId: number;
  brandInfoId?: any;
  skuName: string;
  productSpecList: ProductSpecList[];
  industrySpecList?: any;
  chooseType: number;
  skuUnitId: number;
  unitName: string;
  must: number;
  flag: number;
}

export interface ProductSpecList {
  id: number;
  productSpec: number;
  productSkuId: number;
  specName: string;
  specImage: string;
  partNo: string;
  versionDesc: string;
  createTime?: any;
  productSpecCPQVO: ProductSpecCPQVO;
}

export interface ProductSpecCPQVO {
  productSpecId: number;
  type: number;
  leaseTerm?: any;
  specPrice: any[];
}

export interface GoodsDetail {
  id: number;
  goodsDesc: string;
  content: string;
  remark?: any;
}

export interface Image {
  id: number;
  imgUrl: string;
  imgType: number;
}

interface CommitMallOrderParams {
  buyNum: number;
  directoryId: number;
  goodsInfoId: number;
  mallSpecIds: any[];
  remark: string;
  userAddressId: number;
}

export default {
  //web-获取商品详细信息--共多少种选择
  getLeaseGoodsDetail(
    params: GetLeaseGoodsDetailParams,
  ): Promise<Response<GetLeaseGoodsDetailResp>> {
    return request('/pms/product/mall/getLeaseGoodsDetail', 'get', params);
  },
  //提交订单V1.0.0
  commitMallOrder(params: CommitMallOrderParams) {
    return request('/oms/app-order/commitMallOrder', 'post', params);
  },
};
