import request, { Response } from '~/api/request';

export interface TypeResp {
  id: number;
  typeName: string;
}

export interface PublishParams {
  publishPhone: number; //手机号
  publishName: string; //发布名称
  requirementTypeId: number; //需求类型
  requireDescription: string; //需求描述
  provinceCode?: string; //省编码
}

export default {
  /**
   * 需求类型
   * @returns
   */
  listType(): Promise<Response<Array<TypeResp>>> {
    return request('/release/requirements/listType');
  },
  /**
   * 需求发布
   * @param params
   * @returns
   */
  publish(params: PublishParams): Promise<Response<any>> {
    return request('/release/requirements/publish', 'post', params);
  },
};
