import { useState, useEffect } from 'react';

import { Space, Button, Collapse } from 'antd';
import Image from 'next/image';

import downArrowImg from '~/assets/images/down-arrow.png';

import { FilterOptionResp, InfoList } from '../../api';
import styles from '../../index.module.scss';

type Props = {
  onChange: (id: FilterOptionResp) => void;
  typeName: string;
  dataValue: InfoList[];
  categoryMouseEnter: (item: FilterOptionResp) => void;
  changeCurrentItemIndex: (index: number) => void;
  currentItemIndex: number;
  categoryMouseLeave: () => void;
};

export default function CategoryItem(props: Props) {
  const [data, setData] = useState<FilterOptionResp[]>([]);

  useEffect(() => {
    setData(props.dataValue || []);
  }, []);

  const onClick = (item: FilterOptionResp) => {
    if (!item.children) {
      props.onChange({
        id: item.id,
        name: `${props.typeName}：${item.name}`,
      });
    }
  };
  const onMouseEnter = (item: FilterOptionResp, index: number) => {
    if (item.children) {
      props.changeCurrentItemIndex(index);
    } else {
      props.changeCurrentItemIndex(-1);
    }
    props.categoryMouseEnter({
      id: item.id,
      name: `${props.typeName}：${item.name}`,
      children: item.children,
    });
  };

  const showCount = 9; // 展示数量

  return (
    <div className={styles.filterItem}>
      <div className={styles.filterItemTitle}>{props.typeName}：</div>
      <div className={`${styles.filterItemMain} ${data.length <= showCount && styles.disabled}`}>
        <Collapse ghost collapsible='icon' expandIconPosition='end' style={{ width: '100%' }}>
          <Collapse.Panel
            header={
              <Space size={[10, 0]}>
                {data.slice(0, showCount).map((item, index) => {
                  return (
                    <div
                      key={item.id}
                      className={`${styles.filterItemContent} ${
                        props.currentItemIndex === index ? styles.filterItemContentHover : ''
                      }`}
                      onMouseEnter={() => onMouseEnter(item, index)}
                      onMouseLeave={props.categoryMouseLeave}
                    >
                      <Button type='link' onClick={(e) => onClick(item)}>
                        {item.name}
                      </Button>
                      {item.children ? (
                        <Image
                          src={downArrowImg}
                          className={styles.filterItemIcon}
                          width={14}
                          height={14}
                          alt='展开图标'
                        />
                      ) : (
                        ''
                      )}
                    </div>
                  );
                })}
              </Space>
            }
            key='1'
          >
            <Space size={40}>
              {data.slice(showCount).map((item) => {
                return (
                  <Button type='link' key={item.id} onClick={(e) => onClick(item)}>
                    {item.name}
                  </Button>
                );
              })}
            </Space>
          </Collapse.Panel>
        </Collapse>
      </div>
    </div>
  );
}
