import request, { Response } from "~/api/request"

export interface QueryOrderTaskListParams {
  orderStatus?: number;
  pageNo: number;
  pageSize: number;
}

export interface QueryOrderTaskListResp {
  pageNo: number;
  pageSize: number;
  list: OrderList[];
  totalCount: number;
  totalPage: number;
}

export interface OrderList {
  address: string;
  city: string;
  endTime: string;
  images: any[];
  inspectionId: number;
  lat: number;
  lon: number;
  orderAmt: number;
  orderName: string;
  orderNo: string;
  province: string;
  startTime: string;
  taskDescription: string;
}


export interface ListStatusResp {
  status: string;
  code: number;
  nextCode: number;
}

export default {
  //查询服务订单列表
  queryOrderTaskList(params: QueryOrderTaskListParams, options: any): Promise<Response<QueryOrderTaskListResp>> {
    return request('/pms/serviceOrderTask/queryOrderTaskList', 'post', params, options)
  },

  //订单状态-字典
  listStatus(): Promise<Response<ListStatusResp[]>> {
    return request('/oms/mallorder/listStatus', 'get');
  }
}