import request, { Response } from '~/api/request';

export interface ListPageJobInfoParams {
  pageNo:number,	
  pageSize:number,
  appTypeId?:number,	
  industryId?:number,	
  inspectionName?:string,	
  string?:number,
  regionId?:number,	
}

export interface JobDetail {
        id?: number,
        content?: string,
        contentImgs?: string[] | null,
        contentVideo?: string | null,
        star?: number,
        img?: string | null,
        type?: number,
        name?:string,
        time?:number | string
}

export interface ListPageJobInfoResp {
    id: number,
    serviceName: string,
    pictureUrl: string,
    videoUrl: string,
    teamPoster:string,
    evaluateInfo:Array<JobDetail>,
    item:number
}

export interface GetJobServicesDetailParams {
  id: number
}

export default {
  //web-作业服务-详情
  listDetailJobServicesInfo: (params:GetJobServicesDetailParams): Promise<Response<ListPageJobInfoResp>> => {
    return request('/release/work/selectInspection', 'get', params)
  },
}