import request, { Response } from '~/api/request'

export interface FilterOptionResp {
  id: number
  name?: string
  appName?: string
}

export interface RegionResp {
  childInfo: RegionResp[] | null
  id: number
  level: number
  name: string
  pid: number
}

export interface InfoList {
  id: number
  directoryId: number
  name: string
  icon: string
}
export interface TypesResp {
  directoryId: number
  name: string
  categoriesInfoListDTO: InfoList[]
}

export default {
  category: (): Promise<Response<Array<FilterOptionResp>>> => {
    return request('/pms/webProductMall/category')
  },
  categoryId: (): Promise<Response<Array<FilterOptionResp>>> => {
    return request('/pms/webDevice/category')
  },
  brand: (): Promise<Response<Array<FilterOptionResp>>> => {
    return request('/pms/webDevice/brand')
  },
  model: (): Promise<Response<Array<FilterOptionResp>>> => {
    return request('/pms/webDevice/model')
  },
  part: (): Promise<Response<Array<FilterOptionResp>>> => {
    return request('/pms/webProductMall/parts')
  },
  quality: (): Promise<Response<Array<FilterOptionResp>>> => {
    return request('/pms/webProductMall/quality')
  },
  region: (): Promise<Response<Array<RegionResp>>> => {
    return request('/pms/webDevice/getSecondDistrictInfo')
  },
  industry: (): Promise<Response<Array<RegionResp>>> => {
    return request('/release/work/listAllIndustry')
  },
  appType: (): Promise<Response<Array<RegionResp>>> => {
    return request('/release/work/listAllAppType')
  },
  deviceBrand: (): Promise<Response<Array<RegionResp>>> => {
    return request('/pms/webDevice/deviceBrand')
  },
  deviceModel: (): Promise<Response<Array<RegionResp>>> => {
    return request('/pms/webDevice/deviceModel')
  },
  infoByType: (params: {
    type: number
  }): Promise<Response<Array<TypesResp>>> => {
    return request('/pms/classify/queryCategoryInfoByType', 'get', params)
  },
}
