// user.ts
import { createSlice } from '@reduxjs/toolkit';
import { HYDRATE } from 'next-redux-wrapper';
import { LocationType } from '@/utils/getLocationByIP';

export type AddressState = LocationType;

const initialState: AddressState | {} = {};

const addressSlice = createSlice({
  name: 'address',
  initialState,
  reducers: {
    setAddress: (state, action) => {
      return action.payload;
    },
  },
  extraReducers: {
    // hydrated 用于获取服务端注入的state并选择更新
    [HYDRATE]: (state, action) => {
      return {
        ...action.payload.address,
      };
    },
  },
});

export const { setAddress } = addressSlice.actions;
export default addressSlice.reducer;
