import React, { useEffect } from 'react';
import { Button } from 'antd';
import { useRouter } from 'next/router';
import { CommonAPI } from '@/api';
import LayoutView from '@/components/layout';

// 每次加载页面都会执行
export async function getServerSideProps() {
  // 分类数据
  let categoryData = {};
  // 获取分类数据
  const getPageHomeCategories = async () => {
    const res = await CommonAPI.getPageHomeCategories({
      type: 4,
    });
    if (res && res.code === '200') {
      categoryData = res;
    }
  };
  // 依次获取接口数据
  await (async () => {
    await getPageHomeCategories();
  })();
  return { props: { categoryData } };
}
const MallView = (props: any) => {
  // 路由钩子
  const router = useRouter();
  // 获取接口数据
  const getCooperationListTag = async () => {
    const res = await CommonAPI.cooperationListTag();
    if (res && res.code === '200') {
      console.log('获取接口数据 --->', res);
    }
  };
  useEffect(() => {
    getCooperationListTag().then();
    console.log('执行到此处12312 --->', props);
  }, [props]);
  return (
    <>
      <LayoutView placeholder={true}>
        <div>测试</div>
        <Button
          onClick={() => {
            router.back();
          }}
        >
          返回
        </Button>
      </LayoutView>
    </>
  );
};

export default MallView;
