import React, { useState } from 'react';
import { useDispatch, useSelector } from 'react-redux';
import ContentView from '@/components/layout/content';
import FooterView from '@/components/layout/footer';
import HeaderView from '@/components/layout/header';
import { LayoutWrap } from '@/components/layout/styled';
import LoginModalView from '@/components/loginModal';
import QrcodeModalView from '@/components/qrcodeModal';
import { RootState } from '@/store';
import { GlobalDataState, setGlobalData } from '@/store/module/globalData';

const LayoutView: React.FC<{
  children?: React.ReactNode;
  placeholder?: boolean;
}> = ({ children, placeholder }) => {
  // 打开二维码弹窗
  const [qrcodeShow, setQrcodeShow] = useState<boolean>(false);
  // store
  const dispatch = useDispatch();
  // system
  const globalData = useSelector(
    (state: RootState) => state.globalData,
  ) as GlobalDataState;
  // 关闭弹窗
  const handleClose = () => {
    dispatch(
      setGlobalData({
        loginModalVisible: false,
      }),
    );
  };
  return (
    <div className={'animate__animated animate__faster animate__fadeIn'}>
      <LayoutWrap>
        <div
          onClick={() => {
            // setQrcodeShow(!qrcodeShow);
          }}
        >
          {placeholder ? (
            <HeaderView placeholder={true}></HeaderView>
          ) : (
            <HeaderView placeholder={false}></HeaderView>
          )}
          <ContentView>{children}</ContentView>
          <FooterView></FooterView>
        </div>
        {/* 登录弹窗 */}
        <LoginModalView
          open={globalData?.loginModalVisible}
          onCancel={handleClose}
        />
        {/* 功能正在完善中 */}
        <QrcodeModalView
          open={qrcodeShow}
          onCancel={() => setQrcodeShow(false)}
        />
      </LayoutWrap>
    </div>
  );
};

export default LayoutView;
