import React from 'react';
import { RightOutlined } from '@ant-design/icons';
import styled from 'styled-components';

const HomeTitleView = ({ title }: { title: string }) => {
  return (
    <HomeTitleWrap>
      <div className="title-text">{title}</div>
      <div className="title-more flex-start">
        <div className="more-text">更多</div>
        <RightOutlined style={{ fontSize: 10, color: '#fff' }} />
      </div>
    </HomeTitleWrap>
  );
};
export const HomeTitleWrap = styled.div`
  position: relative;
  width: 100%;
  height: 4.38rem;
  //background: rgba(49, 49, 49, 0.67);
  opacity: 1;
  box-sizing: border-box;
  display: flex;
  align-items: center;
  justify-content: center;
  background-image: url('https://pad-video-x.oss-cn-shenzhen.aliyuncs.com/file/sharefly-web-headbg.png');
  background-size: cover;
  background-position: center;
  z-index: 1;
  &::after {
    position: absolute;
    content: '';
    top: 0;
    left: 0;
    width: 100%;
    height: 100%;
    z-index: -1;
    background: rgba(49, 49, 49, 0.25);
  }
  &:hover&::after,
  &:active&::after {
    background: rgba(49, 49, 49, 0.15);
  }
  .title-text {
    font-size: 1.67rem;
    font-weight: bold;
    color: #ffffff;
    letter-spacing: 12px;
  }
  .title-more {
    position: absolute;
    right: 0.8rem;
    .more-text {
      font-size: 13px;
      font-weight: 400;
      color: #ffffff;
      margin-right: 0.2rem;
    }
  }
`;
export default HomeTitleView;
