import { Empty, Pagination, Spin } from "antd";
import React, { useState, useEffect } from "react";
import api, { Item } from "./api";
import styles from "./index.module.scss";

type Props = {
  params?: {
    cityCode: number; //市编码
    date: string; //时间 2023-05-19
    districtCode: number; //区编码
    provinceCode: number; //省编码
  };
};

export default function Requirements(props: Props) {
  const [loading, setLoading] = useState(false);
  const [list, setList] = useState<Array<Item>>([]);
  const [pageParams, setPageParams] = useState({
    pageNo: 1,
    pageSize: 5,
  });
  const [count, setCount] = useState(0);
  const [abort, setAbort] = useState<AbortController | null>(null);

  useEffect(() => {
    //中断前一次请求
    abort?.abort();
    setAbort(new AbortController());
  }, [pageParams, props.params]);

  useEffect(() => {
    if (!abort) {
      return;
    }
    setLoading(true);
    api
      .listPublishPage(
        {
          ...pageParams,
        },
        {
          signal: abort?.signal,
        }
      )
      .then((res) => {
        setList(res.result?.list || []);
        setCount(res.result?.totalCount || 0);
        setLoading(false);
      });
  }, [abort]);

  const onPageChange = (page: number, pageSize: number) => {
    setPageParams({
      ...pageParams,
      pageNo: page,
    });
  };

  return (
    <Spin spinning={loading} delay={500}>
      <div className={styles.requirements} style={{ height: 557 }}>
        {list.map((item) => {
          return (
            <div
              className={`${styles.item} ${!item.solved && styles.noResolve}`}
              key={item.id}
            >
              <div className={styles.logo}></div>
              <div className={styles.info}>
                <div className={styles.title}>
                  项目需求：电力巡检需要5名飞手
                </div>
                <div className={styles.desc}>
                  具体需求：{item.requireDescription}
                </div>
              </div>
            </div>
          );
        })}

        {list.length === 0 && <Empty></Empty>}
      </div>
      <Pagination
        current={pageParams.pageNo}
        defaultPageSize={pageParams.pageSize}
        showSizeChanger={false}
        showQuickJumper
        total={count}
        onChange={onPageChange}
        hideOnSinglePage={true}
        style={{ marginTop: 20 }}
      />
    </Spin>
  );
}
