import React, { useEffect, useState } from "react";
import { Space, Select, Button } from "antd";
import Image from "next/image";
import { useRouter } from "next/router";
import { Box } from "./styled";
import ContentBox from "~/components/contentBox";
import RotationChart from "./components/rotationChart";
import Map from "./components/map";

import tubiao from "./assets/tubiao.png";
import fuwu from "./assets/fuwu.png";
import xiaoshou from "./assets/xiaoshou.png";
import baoxian from "./assets/baoxian.png";
import peixun from "./assets/peixun.png";
import gongju from "./assets/gongju.png";
const icon = [tubiao, fuwu, xiaoshou, baoxian, peixun, gongju];
import {
  FilterOptionResp,
  RegionResp,
  AllType,
  AppType,
  IndustryType,
  SkillsType,
  NewsPageType,
  NewsTenderType,
  equipmentLeasingApi,
  jobServicesApi,
  mallApi,
  flightSkillsApi,
  listNewsApi,
} from "./api";
import { BaseOptionType, DefaultOptionType } from "antd/es/select";

interface ColumnsType {
  title: string;
  router: string;
}

export default function WaterfallFlowBody() {
  const router = useRouter();
  const onMoreChange = (value: string) => {
    console.log("更多", value);
  };
  const [list, setList] = useState([
    "中国人寿",
    "中国平安",
    "中国人保",
    "太平洋保险",
    "新华保险",
    "中国太平",
    "泰康保险",
    "华夏保险",
    "阳光保险",
    "友邦保险",
    "富德生命人寿",
    "中邮人寿",
    "前海人寿",
    "百年人寿",
    "国华人寿",
    "工银安盛人寿",
    "恒大人寿",
    "君康人寿",
    "友邦保险",
    "建信人寿",
    "大家人寿",
    "农银人寿",
    "中信保城人寿",
    "合众人寿",
  ]);
  const [list2, setList2] = useState([
    "天目将PAAS平台",
    "天目将公安平台",
    "天目将应急平台",
    "天目将城管平台",
    "天目将电力平台",
    "天目将石油平台",
    "SESP-U1无人机仿真软件",
    "云享飞服务号",
    "无人机商城",
    "云飞手",
    "云仓",
    "云享飞",
    "科比特智教",
  ]);
  //  const [brandData,setBrandData] = useState<FilterOptionResp[]>([])

  const [moreEqList, setMoreEqList] = useState<any>();

  const columns = [
    {
      title: "无人机出租",
      router: "/equipmentLeasing",
    },
    {
      title: "无人机服务",
      router: "/jobServices",
    },
    {
      title: "无人机销售",
      router: "/mall",
    },
    {
      title: "无人机保险",
      router: "",
    },
    {
      title: "无人机培训",
      router: "flyingHandService",
    },
    {
      title: "无人机工具软件",
      router: "",
    },
  ];

  const [leftDomList, setLeftDomList] = useState(
    Array<{ element: JSX.Element }>
  );
  const [rightTopDomList, setRightTopDomList] = useState<JSX.Element>();
  const [rightBottomDomList, setRightBottomDomList] = useState<JSX.Element>();

  const { deviceCategory, deviceBrand, deviceModel } = equipmentLeasingApi;
  const eqApiTypeList = ["categoryId", "brandId", "modelId"];

  const { listAllIndustry, listAllAppType } = jobServicesApi;
  const jobApiTypeList = ["industryId", "appTypeId"];

  const { listAllCategory, listAllParts, listAllQuality } = mallApi;
  const mallApiTypeList = [
    "brandId",
    "productCategoryId",
    "partsId",
    "modelId",
    "qualityId",
  ];

  const { IndustryFlightSkills } = flightSkillsApi;
  const flightApiTypeList = ["licenseId", "flightSkillsId"];

  useEffect(() => {
    (async () => {
      listNewsApi.listNewsPage({ pageNo: 1, pageSize: 10 }).then((res) => {
        setRightTopDomList(rightDom(res.result?.list!));
      });
      listNewsApi.listNewTenderInfo({ pageNo: 1, pageSize: 10 }).then((res) => {
        setRightBottomDomList(rightDom2(res.result?.list!));
      });

      let res1 = await Promise.all([
        deviceCategory(),
        deviceBrand(),
        deviceModel(),
      ]);
      let res2 = await Promise.all([listAllIndustry(), listAllAppType()]);
      let res3 = await Promise.all([
        listAllCategory(),
        listAllParts(),
        listAllQuality(),
      ]);
      //  let res4 = await Promise.all([deviceCategory(),deviceBrand(),deviceModel()])
      let res5 = await Promise.all([IndustryFlightSkills()]);
      //  let res6 = await Promise.all([deviceCategory(),deviceBrand(),deviceModel()])

      const resValuelist1 = res1
        .map((item, index) => {
          return item.result?.map((it) => {
            it.type = eqApiTypeList[index];
            return it;
          });
        })
        .flat();
      const resValuelist2 = res2
        .map((item, index) => {
          return item.result?.map((it) => {
            it.type = jobApiTypeList[index];
            return it;
          });
        })
        .flat();
      const resValuelist3 = res3
        .map((item, index) => {
          return item.result?.map((it) => {
            it.type = mallApiTypeList[index];
            return it;
          });
        })
        .flat();
      const resValuelist5 = res5
        .map((item, index) => {
          return item.result?.map((it) => {
            it.type = flightApiTypeList[index];
            return it;
          });
        })
        .flat();

      let res7 = await listNewsApi.listNewsPage({ pageNo: 1, pageSize: 10 });
      let res8 = await listNewsApi.listNewTenderInfo({
        pageNo: 1,
        pageSize: 10,
      });
      const listValue: any = [
        resValuelist1,
        resValuelist2,
        resValuelist3,
        [],
        resValuelist5.flat(),
        [],
      ];

      setMoreEqList(res1.map((item) => item.result).flat());
      setLeftDomList(
        columns.map((item, index) => {
          return { element: leftDom(item, index, listValue) };
        })
      );

      setRightTopDomList(rightDom(res7.result?.list!));
      setRightBottomDomList(rightDom2(res8.result?.list!));
    })();
  }, []);

  const routerPath = (item: AllType, index: number) => {
    router.push({
      pathname: columns[index].router,
      query: { [item?.type!]: item?.id! },
    });
  };

  const leftDom = (
    item: ColumnsType,
    index: number,
    resultList: Array<Array<AllType>>
  ) => {
    return (
      <div key={item.title} className="item">
        <div className="item-title">
          <div className="item-left">
            <div className="item-left-icon">
              <Image src={icon[index]} alt="#" />
            </div>
            <div className="item-left-label">{item.title}</div>
          </div>
          <div>
            <Select
              placeholder="更多"
              onChange={onMoreChange}
              bordered={false}
              dropdownMatchSelectWidth={false}
              options={moreEqList}
              fieldNames={{ value: "id", label: "name" }}
            />
          </div>
        </div>
        <div className="item-body">
          <Space size={[10, 8]} wrap>
            {index === 3
              ? list.map((item) => (
                  <div key={item} className="item-bubble">
                    {item}
                  </div>
                ))
              : index === 5
              ? list2.map((item) => (
                  <div key={item} className="item-bubble">
                    {item}
                  </div>
                ))
              : resultList[index].map((item) => {
                  return (
                    <div
                      key={item?.name || item?.appName || item?.skillsName}
                      className="item-bubble"
                      onClick={() => routerPath(item, index)}
                    >
                      {item?.name || item?.appName || item?.skillsName}
                    </div>
                  );
                })}
          </Space>
        </div>
      </div>
    );
  };

  const rightDom = (list: Array<NewsPageType>) => {
    return (
      <div key={1} className="right-box-item right-item">
        <div className="title">行业新闻</div>
        <div className="body">
          {list?.map((item) => (
            <div key={item.id} className="body-item">
              <div className="item-label">{item.newsTitle}</div>
              <div className="item-image">
                <Image
                  className="item-image"
                  src={
                    item.surfaceImg
                      ? item.surfaceImg
                      : require("./assets/xw.jpg")
                  }
                  alt="#"
                  width={40}
                  height={40}
                />
              </div>
            </div>
          ))}
        </div>
      </div>
    );
  };

  const rightDom2 = (list: Array<NewsTenderType>) => {
    return (
      <div key={2} className="right-box-item right-item-second">
        <div className="title">招标快讯</div>
        <div className="body">
          {list?.map((item) => (
            <div key={item.id} className="body-item">
              <div className="item-label">
                <div className="label-top" title={item.tenderContent}>
                  {item.tenderContent}
                </div>
                <div className="label-bottom">{item.tenderPrice}</div>
              </div>
              <div className="item-right">
                <Button className="btn" size="small" type="primary">
                  申请合作
                </Button>
              </div>
            </div>
          ))}
        </div>
      </div>
    );
  };

  return (
    <Box>
      <ContentBox
        boxIndex={2}
        leftRenderDom={{
          columns: [
            { noFor: true, element: <RotationChart /> },
            ...leftDomList,
          ],
        }}
        rightRenderDom={{
          columns: [
            { element: <Map /> },
            { element: rightTopDomList as JSX.Element },
            { element: rightBottomDomList as JSX.Element },
          ],
        }}
      />
    </Box>
  );
}
