import React, { Component, useEffect, useState } from "react";
import { Box } from "./styled";
import api from "./api";

export default function MapComponent() {
  const [mapItem, setMapItem] = useState(0);
  let map: any;
  const init = async () => {
    try {
      const AMapLoader = await import(
        /* webpackChunkName: "amap" */ "@amap/amap-jsapi-loader"
      );
      AMapLoader.load({
        key: "87b424e68754efc3ba9d11ae07475091", // 申请好的Web端开发者Key，首次调用 load 时必填
        version: "2.0", // 指定要加载的 JSAPI 的版本，缺省时默认为 1.4.15
        plugins: [""], // 需要使用的的插件列表，如比例尺'AMap.Scale'等
      })
        .then((AMap) => {
          map = new AMap.Map("container", {
            // 设置地图容器id
            viewMode: "3D", // 是否为3D地图模式
            zoom: 11, // 初始化地图级别
            center: [113.93029, 22.53291], // 初始化地图中心点位置
          });
          mapEntiy(0, AMap);
        })
        .catch((e) => {
          console.log(e);
        });
    } catch (error) {
      console.log(error);
    }
  };
  useEffect(() => {
    (async () => {
      await init();
    })();
  }, []);

  const addEntiy = (AMap: any, lan: any, lon: any) => {
    // let lngLat = new AMap.LngLat(lan.trim(), lon.trim())
    // // 转高德坐标系
    // AMap.convertFrom(lngLat, 'gps', function (info, result) {
    //   lngLat = result.locations[0]// 转换后的坐标位置
    //   var marker = new AMap.Marker({
    //     position: lngLat,
    //     map
    //   })
    //   AMap.event.addListener(marker, 'click', (e) => {
    //     map.AMapUI.loadUI(['overlay/SimpleInfoWindow'], function (SimpleInfoWindow) {
    //       var infoWindow = new SimpleInfoWindow({
    //         infoTitle: '<strong>这是标题</strong>',
    //         infoBody: '<p>这是信息</p>',
    //         offset: new AMap.Pixel(0, -20),
    //         autoMove: true
    //       })
    //       infoWindow.open(map, e.target.getPosition())
    //       // 最坑的就是这一步了，他的infowindow没有点击事件，所以infoWindow.get$Container()会返回这个infowindow（jquery）对象
    //       let infoEle = infoWindow.get$Container()
    //       //给infowindow添加点击事件，并在回调函数中处理业务或者跳转等
    //       infoEle.on('click', (e) => {
    //         // router.push({name: 'proinfo', params: pro})
    //       })
    //     })
    //   })
    // })
  };

  const mapEntiy = (index: number, AMap?: any) => {
    api
      .listPositioningInfo({
        lat: 113.944825,
        lon: 22.573664,
      })
      .then((res) => {
        // const list = res.result
        //   ?.map((item) => item.locationList)
        //   .flat()
        //   .filter((item: { dizhi: string }) => item.dizhi.includes("广东省"));
        // console.log("ajksbhdkjasgdbjahks", list);

        // list.map((item) => {
        //   addEntiy(AMap, item.jd, item.wd);
        // });
        setMapItem(index);
      });
  };

  return (
    <Box className="right-box-item">
      <div id="container" className="map"></div>
      <div className="map-dosome">
        <div
          className={mapItem === 0 ? "active" : ""}
          onClick={() => mapEntiy(0)}
        >
          服务网点
        </div>
        <div
          className={mapItem === 1 ? "active" : ""}
          onClick={() => mapEntiy(1)}
        >
          租赁网点
        </div>
        <div
          className={mapItem === 2 ? "active" : ""}
          onClick={() => mapEntiy(2)}
        >
          培训网点
        </div>
        <div
          className={mapItem === 3 ? "active" : ""}
          onClick={() => mapEntiy(3)}
        >
          更多网点
        </div>
      </div>
    </Box>
  );
}
