import React, { useEffect, useState } from "react";
import { Box } from "./styled";
import Image from "next/image";
import { Button, Select, Space, Pagination, Cascader } from "antd";
import Layout from "~/components/layout";
import ContentBox from "~/components/contentBox";
import api, { Flying, SkillsType, RegionResp } from "./api";
import { useRouter } from "next/router";
interface FilterInfoParams {
  regionId?: number;
  flightSkillsId?: number;
  licenseId?: number;
}

export default function FlyingHandService() {
  const router = useRouter();
  const [list, setList] = useState([
    "https://pad-video-x.oss-cn-shenzhen.aliyuncs.com/file/925072db-5872-44dd-8b71-e408ad3adf41.jpg",
    "https://pad-video-x.oss-cn-shenzhen.aliyuncs.com/file/12d624b0-1250-44a6-9a3f-9025725a2adc.jpg",
  ]);
  const [productList, setProductList] = useState(
    Array<{ element: JSX.Element }>
  );
  const [rightDomList, setRightDomList] = useState(
    Array<{ element: JSX.Element }>
  );
  const [secondDistrictInfo, setSecondDistrictInfo] = useState(
    Array<RegionResp>
  );
  const [flightSkillsList, setFlightSkillsList] = useState(Array<SkillsType>);

  const leftDom = (item: Flying) => {
    return (
      <div className="item" key={item.id}>
        <div className="item-top">
          <Image
            src={`${item.videoUrl}?x-oss-process=video/snapshot,t_1000,m_fast`}
            alt="#"
            width={220}
            height={160}
          />
        </div>
        <div className="item-bottom">
          <div className="bottom-title">{item.curriculumName}</div>
          <div className="bottom-details">{item.curriculumDesc}</div>
          <div className="bottom-price">
            <div className="bottom-price-left" title={item.supplierName}>
              {item.supplierName}
            </div>
            <div className="bottom-price-right">
              {item.free ? (
                <div className="price-right-label">{item.price}</div>
              ) : (
                <div>
                  <span className="price-right-label">限免</span>
                  {/* <span className='price-right-money'>{`¥${item.price}`}</span> */}
                </div>
              )}
            </div>
          </div>
        </div>
      </div>
    );
  };

  const rightDom = (item: string) => {
    return (
      <div className="right-box-item right-item" key={item}>
        <Image src={item} alt="error" width={260} height={420} />
      </div>
    );
  };

  const [pageParams, setPageParams] = useState({
    pageNo: 1,
    pageSize: 12,
  }); //分页器对象

  const [filterParams, setFilterParams] = useState<FilterInfoParams>();

  const [count, setCount] = useState(0); //商品总数
  const [abort, setAbort] = useState<AbortController | null>(null); //请求中断

  const onPageChange = (page: number, pageSize: number) => {
    setPageParams({
      ...pageParams,
      pageNo: page,
    });
  };

  useEffect(() => {
    //中断前一次列表请求
    abort?.abort();
    setAbort(new AbortController());
  }, [filterParams, pageParams]);

  //端口列表请求
  useEffect(() => {
    let queryVal = JSON.parse(JSON.stringify(router.query));
    for (const key in queryVal) {
      queryVal[key] = Number(queryVal[key]);
    }
    api
      .listPageJobServicesInfo({
        ...pageParams,
        ...filterParams,
        ...queryVal,
      })
      .then((res) => {
        setProductList(
          res.result?.list?.map((item) => {
            return { element: leftDom(item) };
          }) || []
        );
        setCount(res.result?.totalCount || 0);
      });
  }, [abort]);

  const onProvinceChange = (value: string, type: string) => {
    if (type === "考证") {
      setFilterParams((props) => {
        return {
          ...props,
          licenseId: Number(value),
        };
      });
    } else {
      setFilterParams((props) => {
        return {
          ...props,
          flightSkillsId: Number(value),
        };
      });
    }
  };

  const onChange = (value: any) => {
    setFilterParams((props) => {
      return {
        ...props,
        flightSkillsId: (value && value[value.length - 1]) || undefined,
      };
    });
  };

  useEffect(() => {
    setRightDomList(
      list.map((item: string) => {
        return { element: rightDom(item) };
      })
    );
    api.region().then((res) => {
      setSecondDistrictInfo(res.result || []);
    });

    api.IndustryFlightSkills().then((res) => {
      setFlightSkillsList(res.result || []);
    });
  }, []);

  useEffect(() => {
    if (Object.keys(router.query).length) {
      let queryVal = JSON.parse(JSON.stringify(router.query));
      for (const key in queryVal) {
        queryVal[key] = Number(queryVal[key]);
      }
      setFilterParams((props) => {
        return {
          ...props,
          ...queryVal,
        };
      });
    }
  }, [router]);

  return (
    <Layout>
      <Box>
        <div className="flyingTop">
          <div className="flyingTop-left">
            <Space>
              <Cascader
                allowClear
                placeholder="地域"
                bordered={false}
                className="selectItem"
                size="large"
                fieldNames={{
                  label: "name",
                  value: "id",
                  children: "childInfo",
                }}
                options={secondDistrictInfo}
                onChange={onChange}
                changeOnSelect
              />
              <Select
                className="selectItem"
                bordered={false}
                popupMatchSelectWidth={false}
                placeholder="考证"
                size="large"
                onChange={(value) => onProvinceChange(value, "考证")}
                options={[
                  { value: "1", label: "视距内驾驶员" },
                  { value: "2", label: "视距外驾驶员" },
                  { value: "3", label: "教员" },
                ]}
                allowClear
              />
              <Select
                className="selectItem"
                bordered={false}
                popupMatchSelectWidth={false}
                placeholder="技能"
                size="large"
                onChange={(value) => onProvinceChange(value, "技能")}
                options={flightSkillsList}
                fieldNames={{ value: "id", label: "skillsName" }}
                allowClear
              />
            </Space>
          </div>
          <Button type="primary" className="btn">
            报名学习课程
          </Button>
        </div>
        <ContentBox
          boxIndex={4}
          leftcontentstyle={{
            width: "925px",
            margin: { top: 0, right: "15px", bottom: "15px", left: 0 },
          }}
          leftRenderDom={{ columns: productList }}
          rightRenderDom={{ columns: rightDomList }}
        />
        <Pagination
          current={pageParams.pageNo}
          pageSize={pageParams.pageSize}
          showSizeChanger={false}
          showQuickJumper
          total={count}
          onChange={onPageChange}
          hideOnSinglePage={true}
          style={{ marginTop: 20 }}
        />
      </Box>
    </Layout>
  );
}
