import React, { useEffect, useState } from "react";
import {Box} from './styled';
import { Button, Select, Space, Tag } from "antd";
import Layout from "~/components/layout";
import ContentBox from '~/components/contentBox';

export default function JobServices() {
  const Dom = <div className='item' style={{height:343,backgroundColor:"#ccc"}}>12312312</div>

  const [productList, setProductList] = useState(Array<{}>);

  useEffect(() => {
    setProductList([{}, {}, {}, {}, {}, {}]);
  }, []);

  const onProvinceChange = (value: string) => {
    console.log("省", value);
  };

  const onCityChange = (value: string) => {
    console.log("市", value);
  };

  const onMoreChange = (value: string) => {
    console.log("更多", value);
  };

  const onCloseTag = (e: React.MouseEvent<HTMLElement, MouseEvent>) => {
    console.log("删除", e);
  };

  return  (
    <Layout>
      <Box>
      <div className="filter-wrap" style={{ marginBottom: "11px" }}>
          <div className="filter-item">
            <div className="filter-item__title">地域：</div>
            <div className="filter-item-main">
              <Space size={40}>
                <Select
                  bordered={false}
                  dropdownMatchSelectWidth={false}
                  placeholder="选择省"
                  onChange={onProvinceChange}
                  options={[
                    { value: "jack", label: "Jack" },
                    { value: "lucy", label: "Lucy" },
                    { value: "Yiminghe", label: "yiminghe" },
                    { value: "disabled", label: "Disabled", disabled: true },
                  ]}
                />
                <Select
                  bordered={false}
                  dropdownMatchSelectWidth={false}
                  placeholder="选择市"
                  onChange={onCityChange}
                  options={[
                    { value: "jack", label: "Jack" },
                    { value: "lucy", label: "Lucy" },
                    { value: "Yiminghe", label: "yiminghe" },
                    { value: "disabled", label: "Disabled", disabled: true },
                  ]}
                />
              </Space>
            </div>
          </div>
        </div>
        <div className="filter-wrap" style={{marginBottom:24}}>
          <div className="filter-item">
            <div className="filter-item__title">行业：</div>
            <div className="filter-item-main">
              <Space size={40}>
                <Button type="link">不限</Button>
                <Button type="link">无人机</Button>
                <Button type="link">挂载</Button>
                <Button type="link">地面站</Button>
              </Space>
              <Select
                placeholder="更多"
                onChange={onMoreChange}
                bordered={false}
                dropdownMatchSelectWidth={false}
                options={[
                  { value: "jack", label: "Jack" },
                  { value: "lucy", label: "Lucy" },
                  { value: "Yiminghe", label: "yiminghe" },
                  { value: "disabled", label: "Disabled", disabled: true },
                ]}
              />
            </div>
          </div>
          <div className="filter-item">
            <div className="filter-item__title">服务：</div>
            <div className="filter-item-main">
              <Space size={40}>
                <Button type="link">不限</Button>
                <Button type="link">无人机</Button>
                <Button type="link">挂载</Button>
                <Button type="link">地面站</Button>
              </Space>
              <Select
                placeholder="更多"
                onChange={onMoreChange}
                bordered={false}
                dropdownMatchSelectWidth={false}
                options={[
                  { value: "jack", label: "Jack" },
                  { value: "lucy", label: "Lucy" },
                  { value: "Yiminghe", label: "yiminghe" },
                  { value: "disabled", label: "Disabled", disabled: true },
                ]}
              />
            </div>
          </div>
          <div className="filter-item">
            <div className="filter-item__title">应用：</div>
            <div className="filter-item-main">
              <Space size={40}>
                <Button type="link">不限</Button>
                <Button type="link">无人机</Button>
                <Button type="link">挂载</Button>
                <Button type="link">地面站</Button>
              </Space>
              <Select
                placeholder="更多"
                onChange={onMoreChange}
                bordered={false}
                dropdownMatchSelectWidth={false}
                options={[
                  { value: "jack", label: "Jack" },
                  { value: "lucy", label: "Lucy" },
                  { value: "Yiminghe", label: "yiminghe" },
                  { value: "disabled", label: "Disabled", disabled: true },
                ]}
              />
            </div>
          </div>
          <div className="filter-item">
            <div className="filter-item__title">已选：</div>
            <div className="filter-item-main">
              <Space size={10}>
                <Tag closable onClose={onCloseTag}>
                  无人机
                </Tag>
                <Tag closable onClose={onCloseTag}>
                  无人机
                </Tag>
              </Space>
            </div>
          </div>
        </div>
        <ContentBox boxIndex={2} leftRenderDom={{RenderDom:Dom}} rightRenderDom={{noFor:true,RenderDom:Dom}}/>
      </Box>
    </Layout>
  )
}
