import styled from "styled-components"
export interface BoxProps {
    index:number
}

export const Box = styled.div<BoxProps>`
    box-sizing: border-box;
    width:790px;
    display: flex;
    flex-wrap: wrap;
    .item{
			// 每个元素都要设置右边距margin-right（每个元素的左右间隙）
			// 同时设置下边距margin-bottom（每个元素的上下间隙）
			margin: 0 24px 15px 0;
			width: calc((100% - ${props => props.index - 1} * 24px) / ${props => props.index});   
			// 这里一行显示index个，所以是/index，一行显示几个就除以几 
			// 这里的72px = (分布个数index-1)*间隙20px, 可以根据实际的分布个数和间隙区调整
			min-width: calc((100% - ${props => props.index - 1} * 24px) / ${props => props.index});
			max-width: calc((100% - ${props => props.index - 1} * 24px) / ${props => props.index});
			// 每行最右侧的那个不设置右外边距
			&:nth-child(${props => props.index}n + ${props => props.index}) {
				margin-right: 0;
			} 
		}
`