import React, { useEffect, useState } from 'react';
import { RightOutlined } from '@ant-design/icons';
import styled from 'styled-components';
import { HomeAPI } from '@/api';
import QrcodePopover from '@/components/qrcodePopover';

const HomeNewsView = () => {
  // 帖子类型
  const indexList = [
    { label: 1, value: '#FF392B' },
    { label: 2, value: '#FE792B' },
    { label: 3, value: '#FEA32B' },
  ];
  // 热门类型
  const typeList = [
    { label: 1, value: '#FFB555' },
    { label: 2, value: '#FF6155' },
    { label: 3, value: '#B700D9' },
  ];
  // tab栏数据
  const [tabList, setTabList] = useState<{ label: string; value: any[] }[]>([
    // {
    //   label: '热门话题',
    //   value: [],
    // },
    {
      label: '热点资讯',
      value: [],
    },
    // {
    //   label: '行业新闻',
    //   value: [],
    // },
    {
      label: '招标快讯',
      value: [],
    },
  ]);
  // 刷新子组件
  const [refresh, setRefresh] = useState(true);
  // tab栏索引
  const [currentIndex, setCurrentIndex] = useState<number>(0);
  // 获取话题列表
  const getListGambit = async () => {
    const res = await HomeAPI.getAppGambitList({
      pageNo: 1,
      pageSize: 10,
    });
    if (res && res.code === '200') {
      tabList[0].value = res.result.list || [];
      setTabList(tabList);
      setRefresh(true);
      // console.log('话题列表 --->', tabList);
    }
  };
  // 热点资讯列表
  const getListNews = async () => {
    const res = await HomeAPI.getListNews({
      pageNo: 1,
      pageSize: 10,
    });
    if (res && res.code === '200') {
      tabList[0].value = res.result.list || [];
      setTabList(tabList);
      setRefresh(true);
      // console.log('热点资讯列表 --->', tabList);
    }
  };
  // 获取招标快讯列表
  const getListTenderInfo = async () => {
    const res = await HomeAPI.getListTenderInfo({
      pageNo: 1,
      pageSize: 10,
    });
    if (res && res.code === '200') {
      tabList[1].value = res.result.list || [];
      setTabList(tabList);
      setRefresh(true);
      // console.log('招投标列表 --->', tabList);
    }
  };
  // 选择tab栏
  const handleSelect = async (index: number) => {
    setRefresh(false);
    setCurrentIndex(index);
    if (index === 0) {
      await getListNews();
      return;
    }
    if (index === 1) {
      await getListTenderInfo();
    }
  };
  // 获取标签颜色
  const getTagBgColor = (item: any[0]) => {
    return typeList.find((i) => i.label === item.gambitProperty)?.value;
  };
  // 组件挂载
  useEffect(() => {
    handleSelect(0).then();
    // console.log('执行到此处 --->', tabList);
  }, []);

  return (
    <HomeNewWrap>
      <div className="news-head flex-between">
        <div className="head-tab flex-start">
          {tabList?.map((i, j) => (
            <div
              className={`tab-item ${currentIndex === j && 'tab-active'}`}
              key={j}
              onClick={() => handleSelect(j)}
            >
              {i?.label}
            </div>
          ))}
        </div>
        <QrcodePopover path={'page-home/news-list/index'}>
          <div className="head-more flex-between">
            <div className="more-text">更多</div>
            <RightOutlined style={{ fontSize: 10, color: '#33333380' }} />
          </div>
        </QrcodePopover>
        <img
          className="head-bg"
          src="https://pad-video-x.oss-cn-shenzhen.aliyuncs.com/file/sharefly-web-news.png"
          alt="更多"
        />
      </div>
      <div className="news-list">
        {refresh &&
          tabList?.[currentIndex]?.value?.map((i, j) => (
            <div
              className="animate__animated animate__fast animate__fadeIn flex-start list-item"
              key={j}
            >
              <div
                className="item-index"
                style={{ color: indexList[j]?.value }}
              >
                {j + 1}
              </div>
              <div className="item-title text-ellipsis">
                {i?.gambitName || i?.newsTitle || i?.tenderTitle}
              </div>
              {/* {currentIndex === 0 && ( */}
              {/*  <div */}
              {/*    className="item-tag" */}
              {/*    style={{ backgroundColor: getTagBgColor(i) }} */}
              {/*  > */}
              {/*    {i?.gambitProperty === 1 && '新'} */}
              {/*    {i?.gambitProperty === 2 && '热'} */}
              {/*    {i?.gambitProperty === 3 && '荐'} */}
              {/*  </div> */}
              {/* )} */}
            </div>
          ))}
      </div>
    </HomeNewWrap>
  );
};

// 样式
const HomeNewWrap = styled.div`
  height: calc((100% - 1rem) / 2);
  width: 25rem;
  //background: lightblue;
  border: 0.04rem solid #e3e3e3;
  background: linear-gradient(180deg, #ffe3d8 0%, #ffffff 21%);
  .news-head {
    position: relative;
    width: 100%;
    padding: 0 1.29rem;
    .head-tab {
      position: relative;
      width: calc(100% - 5rem);
      box-sizing: border-box;
      padding: 0.83rem 0;
      z-index: 2;
      .tab-item {
        width: 25%;
        font-size: 13px;
        font-weight: 500;
        color: rgba(51, 51, 51, 0.6);
        cursor: pointer;
      }
      .tab-active {
        position: relative;
        font-size: 14px;
        color: #333333;
        font-weight: 550;
        z-index: 1;
        &::after {
          content: '';
          position: absolute;
          bottom: 0;
          left: 50%;
          transform: translateX(-50%);
          width: 2.54rem;
          height: 0.29rem;
          border-radius: 1rem;
          background: #ff6d00;
          z-index: -1;
        }
      }
    }
    .head-more {
      align-items: center;
      z-index: 2;
      cursor: pointer;
      .more-text {
        font-size: 13px;
        font-weight: 400;
        color: rgba(51, 51, 51, 0.5);
      }
    }
    .head-bg {
      position: absolute;
      top: 0;
      right: 2.68rem;
      width: 5.25rem;
      height: 2.02rem;
      z-index: 0;
    }
  }
  .news-list {
    position: relative;
    width: 100%;
    height: 12rem;
    overflow: hidden;
    overflow-y: auto;
    box-sizing: border-box;
    padding: 0 1.2rem;
    &::-webkit-scrollbar-thumb {
      background: #d9d9d9;
      -webkit-border-radius: 2em;
      -moz-border-radius: 2em;
      border-radius: 2em;
      cursor: pointer;
    }
    &::-webkit-scrollbar {
      background-color: transparent;
      -webkit-border-radius: 2em;
      -moz-border-radius: 2em;
      border-radius: 2em;
      width: 7px;
      height: 7px;
    }
    .list-item {
      position: relative;
      width: 100%;
      margin-bottom: 0.5rem;
      .item-index {
        width: 1.5rem;
        font-size: 14px;
        font-weight: 550;
        color: #c3c3c3;
      }
      .item-title {
        max-width: 80%;
        font-size: 14px;
        font-weight: 500;
        color: #333333;
        &:hover,
        &:active {
          cursor: pointer;
          color: #ff6d00;
        }
      }
      .item-tag {
        width: 1rem;
        height: 1rem;
        background: #ff6256;
        border-radius: 0.17rem 0.17rem 0.17rem 0.17rem;
        text-align: center;
        line-height: 1rem;
        font-size: 12px;
        font-weight: 500;
        color: #fff;
        margin-left: 0.33rem;
      }
    }
  }
`;
export default HomeNewsView;
