import React, { useEffect, useState } from 'react';
import { useSelector } from 'react-redux';
import styled from 'styled-components';
import { HomeAPI } from '@/api';
import MapContainer from '@/components/map';
import { RootState } from '@/store';
import { AddressState } from '@/store/module/address';

const HomeMapView = () => {
  // 选择索引
  const [currentIndex, setCurrentIndex] = useState<number>(0);
  // 网点类型
  const networkTypeList = [
    { type: 0, name: '飞手团队', action: '派单', tagId: 5 },
    { type: 1, name: '租赁商家', action: '租设备', tagId: 3 },
    { type: 2, name: '培训机构', action: '报名培训', tagId: 4 },
    { type: 3, name: '维修网点', action: '维修设备', tagId: 10 },
  ];
  // 选择事件
  const handleSelect = (index: number) => {
    setCurrentIndex(index);
    getServiceBitmap().then();
  };
  // address
  const address = useSelector(
    (state: RootState) => state.address,
  ) as AddressState;
  // 地图网点列表
  const [mapMarkerList, setMapMarkerList] = useState<
    { lat: number; lon: number; name: string }[]
  >([]);
  // 统一获取网点数据
  const getServiceBitmap = async () => {
    const res = await HomeAPI.listCompanyInfoByCoopId({
      lon: 113.93029,
      lat: 22.53291,
      pageNo: 1,
      pageSize: 9999,
      coopId: networkTypeList[currentIndex].tagId,
    });
    if (res && res.code === '200') {
      const list = (res.result.list || [])?.map((i) => ({
        ...i,
        name: i.brandName || i.companyName,
      }));
      setMapMarkerList(list);
      // console.log('统一获取网点数据 --->', res);
    }
  };
  // 组件挂载
  useEffect(() => {
    getServiceBitmap().then();
  }, []);
  return (
    <HomeMapWrap>
      <MapContainer
        list={mapMarkerList}
        center={[address?.longitude, address?.latitude]}
      />
      <div className="map-wrap flex-around">
        {networkTypeList?.map((i, j) => (
          <div
            className={`map-item ${j === currentIndex && 'item-active'}`}
            key={j}
            onClick={() => handleSelect(j)}
          >
            {i?.name}
          </div>
        ))}
      </div>
    </HomeMapWrap>
  );
};
export const HomeMapWrap = styled.div`
  position: relative;
  height: calc((100% - 1rem) / 2);
  width: 25rem;
  //background: lightblue;
  border: 0.04rem solid #e3e3e3;
  margin-bottom: 1rem;
  .map-wrap {
    position: absolute;
    bottom: 0;
    left: 0;
    width: 100%;
    height: 2.85rem;
    background: #ffffff;
    z-index: 2;
    .map-item {
      position: relative;
      width: 25%;
      text-align: center;
      font-size: 13px;
      font-weight: 500;
      color: #333333;
      cursor: pointer;
      &::after {
        position: absolute;
        content: '';
        top: 0.2rem;
        right: 0;
        width: 0.04rem;
        height: 0.83rem;
        background: #e2e2e2;
      }
      &:last-child::after {
        display: none;
      }
      &:hover,
      &:active {
        color: #ff552d;
      }
    }
    .item-active {
      color: #ff552d;
      //&:hover,
      //&:active {
      //  color: #333333;
      //}
    }
  }
`;
export default HomeMapView;
