import React from "react";
import { Carousel } from "antd";
import { Box } from "./styled";
import Image from "next/image";

export default function RotationChart() {
  const list = [
    "https://pad-video-x.oss-cn-shenzhen.aliyuncs.com/file/pc%E7%AB%AF%E8%BD%AE%E6%92%AD%E5%9B%BE1.png",
    "https://pad-video-x.oss-cn-shenzhen.aliyuncs.com/file/ebf4fd5d-f8da-45b7-b0b3-282a31e43929.png",
    "https://pad-video-x.oss-cn-shenzhen.aliyuncs.com/file/6b62ee5b-d929-4dee-b441-258c81c14403.png",
    "https://pad-video-x.oss-cn-shenzhen.aliyuncs.com/file/0dd9e0f6-c1cd-485a-bdf4-8aeb84b1c67a.png",
    "https://pad-video-x.oss-cn-shenzhen.aliyuncs.com/file/bcdabab5-f2f8-4c6d-85c6-4d304d8bfe4c.png",
  ];
  return (
    <Box>
      <Carousel
        className="rotationChart"
        autoplay
        dots={{ className: "botsBotton" }}
      >
        {list.map((item) => (
          <div key={item}>
            <h3 className="contentStyle">
              <Image src={item} alt="error" width={806} height={200} />
            </h3>
          </div>
        ))}
      </Carousel>
    </Box>
  );
}
