import React, { Component, useEffect, useState } from "react";
import { Box } from "./styled";
import api from "./api";
import icon from "./assets/icon.png";
let Map: any;
export default function MapComponent() {
  const [mapItem, setMapItem] = useState(0);
  const init = async () => {
    try {
      const AMapLoader = await import(
        /* webpackChunkName: "amap" */ "@amap/amap-jsapi-loader"
      );
      AMapLoader.load({
        key: "87b424e68754efc3ba9d11ae07475091", // 申请好的Web端开发者Key，首次调用 load 时必填
        version: "2.0", // 指定要加载的 JSAPI 的版本，缺省时默认为 1.4.15
        plugins: [""], // 需要使用的的插件列表，如比例尺'AMap.Scale'等
      })
        .then(async (AMap) => {
          Map = new AMap.Map("container", {
            // 设置地图容器id
            viewMode: "3D", // 是否为3D地图模式
            zoom: 9, // 初始化地图级别
            center: [113.93029, 22.53291], // 初始化地图中心点位置
          });
          console.log(Map, "MapMapMapMapMapMapMapMapMapMapMap");

          await mapEntiy(0, AMap);
        })
        .catch((e) => {
          console.log(e);
        });
    } catch (error) {
      console.log(error);
    }
  };
  useEffect(() => {
    (async () => {
      await init();
    })();
    console.log("渲染6666666666666666666666");
  }, []);

  const addEntiy = (AMap: any, lan: any, lon: any, dizhi: string) => {
    if (!AMap) return;
    // 创建 AMap.Icon 实例：
    const Icon = new AMap.Icon({
      size: new AMap.Size(40, 50), // 图标尺寸
      image: "//webapi.amap.com/theme/v1.3/images/newpc/way_btn2.png", // Icon的图像
      imageOffset: new AMap.Pixel(0, -60), // 图像相对展示区域的偏移量，适于雪碧图等
      imageSize: new AMap.Size(40, 50), // 根据所设置的大小拉伸或压缩图片
    });
    // 将 Icon 实例添加到 marker 上:
    const marker = new AMap.Marker({
      position: new AMap.LngLat(lan, lon),
      offset: new AMap.Pixel(-10, -10),
      icon: Icon, // 添加 Icon 实例
      title: dizhi,
      zoom: 9,
      map: Map,
    });
    // const marker = new AMap.Marker({
    //   map: Map,
    //   position: [lan, lon],
    //   title: dizhi,
    // });
    // //鼠标点击marker弹出自定义的信息窗体
    // AMap.Event.addListener(marker, "click", function () {
    //   infoWindow.open(map, marker.getPosition());
    // });

    // //实例化信息窗体
    // var title =
    //     '方恒假日酒店<span style="font-size:11px;color:#F00;">价格:318</span>',
    //   content = [];
    // content.push(
    //   "<img src='http://tpc.googlesyndication.com/simgad/5843493769827749134'>地址：北京市朝阳区阜通东大街6号院3号楼东北8.3公里"
    // );
    // content.push("电话：010-64733333");
    // content.push(
    //   "<a href='https://ditu.amap.com/detail/B000A8URXB?citycode=110105'>详细信息</a>"
    // );
    // var infoWindow = new AMap.InfoWindow({
    //   isCustom: true, //使用自定义窗体
    //   content: createInfoWindow(title, content.join("<br/>")),
    //   offset: new AMap.Pixel(16, -15),
    //   anchor: "bottom-center",
    // });

    // //构建自定义信息窗体
    // function createInfoWindow(title, content) {
    //   var info = document.createElement("div");
    //   info.className = "custom-info input-card content-window-card";

    //   //可以通过下面的方式修改自定义窗体的宽高
    //   //info.style.width = "400px";
    //   // 定义顶部标题
    //   var top = document.createElement("div");
    //   var titleD = document.createElement("div");
    //   var closeX = document.createElement("img");
    //   top.className = "info-top";
    //   titleD.innerHTML = title;
    //   closeX.src = "https://webapi.amap.com/images/close2.gif";
    //   closeX.onclick = closeInfoWindow;

    //   top.appendChild(titleD);
    //   top.appendChild(closeX);
    //   info.appendChild(top);

    //   // 定义中部内容
    //   var middle = document.createElement("div");
    //   middle.className = "info-middle";
    //   middle.style.backgroundColor = "white";
    //   middle.innerHTML = content;
    //   info.appendChild(middle);

    //   // 定义底部内容
    //   var bottom = document.createElement("div");
    //   bottom.className = "info-bottom";
    //   bottom.style.position = "relative";
    //   bottom.style.top = "0px";
    //   bottom.style.margin = "0 auto";
    //   var sharp = document.createElement("img");
    //   sharp.src = "https://webapi.amap.com/images/sharp.png";
    //   bottom.appendChild(sharp);
    //   info.appendChild(bottom);
    //   return info;
    // }

    // //关闭信息窗体
    // function closeInfoWindow() {
    //   map.clearInfoWindow();
    // }

    return marker;
  };

  const mapEntiy = async (index: number, AMap?: any) => {
    // api
    //   .listPositioningInfo({
    //     lat: 113.944825,
    //     lon: 22.573664,
    //   })
    //   .then((res) => {});
    setMapItem(index);
    const res = await api.listPositioningInfo({
      lat: 113.944825,
      lon: 22.573664,
    });
    const list = res.result
      ?.map((item) => item.locationList)
      .flat()
      .filter((item: { dizhi: string }) => item.dizhi.includes("广东省"));
    const markerList: any = [];
    if (list?.length) {
      list?.map((item) => {
        const EntiyValue = addEntiy(AMap, item.jd, item.wd, item.dizhi);
        markerList.push(EntiyValue);
      });
      Map?.add(markerList);
    }
    console.log(Map, "地图实例++++++++++++++++++++++++++++++");

    if (index && list?.length) {
      Map?.panTo([list![index].jd, list![index].wd]);
    }
  };

  return (
    <Box className="right-box-item">
      <div id="container" className="map"></div>
      <div className="map-dosome">
        <div
          className={`itemBox ${mapItem === 0 ? "active" : ""}`}
          onClick={() => mapEntiy(0)}
        >
          服务网点
        </div>
        <div
          className={`itemBox ${mapItem === 1 ? "active" : ""}`}
          onClick={() => mapEntiy(1)}
        >
          租赁网点
        </div>
        <div
          className={`itemBox ${mapItem === 2 ? "active" : ""}`}
          onClick={() => mapEntiy(2)}
        >
          培训网点
        </div>
        <div
          className={`${mapItem === 3 ? "active" : ""}`}
          onClick={() => mapEntiy(3)}
        >
          更多网点
        </div>
      </div>
    </Box>
  );
}
