import request, { Response } from "~/api/request";

export interface AllType {
  type?: string;
  id?: number;
  name?: string;
  appName?: string;
  createTime?: string;
  industryIcon?: string;
  shortName?: null;
  industryType?: null;
  propagate1?: string;
  propagate2?: string;
  image?: string;
  video?: string;
  newsTitle?: string;
  newsAuthor?: string;
  userAccountId?: number;
  surfaceImg?: string;
  newsContents?: string;
  updateTime?: string | null;
  tenderNewsId?: number;
  tenderInfoNo?: string;
  tenderContent?: string;
  tenderPrice?: number;
  apply?: number;
  skillsName?: string;
}

export interface FilterOptionResp {
  type: string;
  id: number;
  name: string;
}

export interface RegionResp {
  childInfo: RegionResp[] | null;
  id: number;
  level: number;
  name: string;
  pid: number;
}

export const equipmentLeasingApi = {
  deviceCategory: (): Promise<Response<Array<FilterOptionResp>>> => {
    return request("/pms/webProductMall/category");
  },
  deviceBrand: (): Promise<Response<Array<FilterOptionResp>>> => {
    return request("/pms/webDevice/deviceBrand");
  },
  deviceModel: (): Promise<Response<Array<FilterOptionResp>>> => {
    return request("/pms/webDevice/deviceModel");
  },
};

export interface AppType {
  id: number;
  name: string;
  appName: string;
  createTime: string;
  type: string;
}

export interface IndustryType {
  id: number;
  industryIcon: string;
  name: string;
  shortName: string;
  industryType: string;
  propagate1: string;
  propagate2: string;
  image: string;
  video: string;
  type: string;
  appName: string;
}

export const jobServicesApi = {
  listAllAppType: (): Promise<Response<Array<AppType>>> => {
    return request("/release/work/listAllAppType");
  },
  listAllIndustry: (): Promise<Response<Array<IndustryType>>> => {
    return request("/release/work/listAllIndustry");
  },
};

export const mallApi = {
  listAllCategory: (): Promise<Response<Array<FilterOptionResp>>> => {
    return request("/pms/webProductMall/category");
  },
  listAllParts: (): Promise<Response<Array<FilterOptionResp>>> => {
    return request("/pms/webProductMall/parts");
  },
  listAllQuality: (): Promise<Response<Array<FilterOptionResp>>> => {
    return request("/pms/webProductMall/quality");
  },
};

export interface SkillsType {
  name: string;
  type: string;
  id: number;
  skillsName: string;
}

export const flightSkillsApi = {
  IndustryFlightSkills: (): Promise<Response<Array<SkillsType>>> => {
    return request("/release/curriculum/getIndustryFlightSkills");
  },
};

export interface NewsPageType {
  id: number;
  newsTitle: string;
  newsAuthor: string;
  userAccountId: number;
  surfaceImg: string;
  newsContents: string;
  createTime: string;
  updateTime: string | null;
}

export interface NewsTenderType {
  id: number;
  tenderNewsId: number;
  tenderInfoNo: string;
  tenderContent: string;
  tenderPrice: number;
  createTime: string;
  apply: number;
}

export interface ListPageNewsInfoResp {
  pageNo: number;
  pageSize: number;
  list: Array<NewsPageType>;
  totalCount: number;
  totalPage: number;
}

export interface ListTenderNewsInfoResp {
  pageNo: number;
  pageSize: number;
  list: Array<NewsTenderType>;
  totalCount: number;
  totalPage: number;
}

interface ListPageNewsInfoParams {
  pageNo: number;
  pageSize: number;
  cityCode?: number;
  date?: string;
  districtCode?: number;
  provinceCode?: number;
}

interface ListTenderNewsInfoParams {
  pageNo: number;
  pageSize: number;
  cityCode?: number;
  date?: string;
  districtCode?: number;
  provinceCode?: number;
}

export const listNewsApi = {
  listNewsPage: (
    params: ListPageNewsInfoParams
  ): Promise<Response<ListPageNewsInfoResp>> => {
    return request("/release/industry-news/listNewsPage", "post", params);
  },
  listNewTenderInfo: (
    params: ListTenderNewsInfoParams
  ): Promise<Response<ListTenderNewsInfoResp>> => {
    return request("/release/tender/listNewTenderInfo", "post", params);
  },
};
