import styled from "styled-components"
export interface BoxProps {
    index:number,
	leftcontentstyle?:{
		width?:string,
		margin?:{
			top:number | string,
			right:number | string,
			bottom:number | string,
			left:number | string
		}
	}
}


export const Box = styled.div<BoxProps>`
    box-sizing: border-box;
    display: flex;
    flex-wrap: wrap;
	width: ${props => props.leftcontentstyle?.width ? props.leftcontentstyle?.width : "790px"};
    .item{
			// 每个元素都要设置右边距margin-right（每个元素的左右间隙）
			// 同时设置下边距margin-bottom（每个元素的上下间隙）
			/* margin: 0 24px 15px 0; */
			margin: ${props => props.leftcontentstyle?.margin ? (`${props.leftcontentstyle?.margin.top} ${props.leftcontentstyle?.margin.right} ${props.leftcontentstyle?.margin.bottom} ${props.leftcontentstyle?.margin.left}`)  : "0 24px 15px 0"};;
			width: calc((100% - ${props => props.index - 1} * ${props => props.leftcontentstyle?.margin ? props.leftcontentstyle?.margin.right : "24px" }) / ${props => props.index});   
			// 这里一行显示index个，所以是/index，一行显示几个就除以几 
			// 这里的72px = (分布个数index-1)*间隙20px, 可以根据实际的分布个数和间隙区调整
			min-width: calc((100% - ${props => props.index - 1} * ${props => props.leftcontentstyle?.margin ? props.leftcontentstyle?.margin.right : "24px" }) / ${props => props.index});
			max-width: calc((100% - ${props => props.index - 1} * ${props => props.leftcontentstyle?.margin ? props.leftcontentstyle?.margin.right : "24px" }) / ${props => props.index});
			// 每行最右侧的那个不设置右外边距
			&:nth-child(${props => props.index}n + ${props => props.index}) {
				margin-right: 0;
			} 
	}
`

export const WaterfallBox = styled.div<BoxProps>`
	box-sizing: border-box;
    display: flex;
	width: ${props => props.leftcontentstyle?.width ? props.leftcontentstyle?.width : "790px"};
    .item{
			// 每个元素都要设置右边距margin-right（每个元素的左右间隙）
			// 同时设置下边距margin-bottom（每个元素的上下间隙）
			/* margin: 0 24px 15px 0; */
			margin: ${props => props.leftcontentstyle?.margin ? (`${props.leftcontentstyle?.margin.top} ${props.leftcontentstyle?.margin.right} ${props.leftcontentstyle?.margin.bottom} ${props.leftcontentstyle?.margin.left}`)  : "0 24px 15px 0"};;
			width: calc(( 100% - ${props => props.index} * ${props => props.leftcontentstyle?.margin ? props.leftcontentstyle?.margin.right : "24px" }) / ${props => props.index});   
			// 这里一行显示index个，所以是/index，一行显示几个就除以几 
			// 这里的72px = (分布个数index-1)*间隙20px, 可以根据实际的分布个数和间隙区调整
			min-width: calc(( 100% - ${props => props.index} * ${props => props.leftcontentstyle?.margin ? props.leftcontentstyle?.margin.right : "24px" }) / ${props => props.index});
			max-width: calc(( 100% - ${props => props.index} * ${props => props.leftcontentstyle?.margin ? props.leftcontentstyle?.margin.right : "24px" }) / ${props => props.index});
			// 每行最右侧的那个不设置右外边距
			&:nth-child(${props => props.index}n + ${props => props.index}) {
				margin-right: 0;
			} 
	}
	.left-columns{

	}
	.right-columns{
		
	}
`