import '../public/antd.min.css';
import '../styles/index.scss';
import type { AppProps } from 'next/app';
import withTheme from '../theme';
import { message } from 'antd';
import { useEffect } from 'react';
import Head from "next/head";
import Script from 'next/script';
import UserProvider, { UserContext } from "~/lib/userProvider";

export default function App({ Component, pageProps }: AppProps) {
  const [messageApi, contextHolder] = message.useMessage();
  useEffect(() => {
    //全局消息提示
    window.messageApi = messageApi;
  }, [])
  
  return withTheme(
    <>
      <Head>
        <meta
          name="viewport"
          content="width=device-width,initial-scale=1"
        ></meta>
      </Head>
      <Script src="https://res.wx.qq.com/connect/zh_CN/htmledition/js/wxLogin.js"></Script>
      {contextHolder}
      <UserProvider>
        <Component {...pageProps} />
      </UserProvider>
    </>
  );
}
