import { WalletAPI } from '@/api';
import { InterDataType } from '@/api/interface';
import { UserPayWalletInfoType } from '@/api/interface/wallet';

// 钱包数据类型
export type CurrentUserPayWalletInfoType = InterDataType<UserPayWalletInfoType>;
// 获取当前用户的钱包信息
const getCurrentUserPayWalletInfo = (): Promise<CurrentUserPayWalletInfoType> =>
  new Promise((resolve, reject) => {
    WalletAPI.getUserPayWalletInfo({})
      .then((res) => {
        if (res && res.code === '200') {
          resolve(res.result);
        } else {
          reject(res.result);
        }
      })
      .catch((err) => {
        reject(err);
      });
  });

export default getCurrentUserPayWalletInfo;
