import React, { useEffect, useState } from 'react';
import { Affix } from 'antd';
import styled from 'styled-components';
import { HomeAPI } from '@/api';
import { InterListType } from '@/api/interface';
import { GetAppGambitListType } from '@/api/interface/home';

// 列表类型
type ListType = InterListType<GetAppGambitListType>;
// 帖子类型
const indexList = [
  { label: 1, value: 'text-[#FF392B]' },
  { label: 2, value: 'text-[#FE792B]' },
  { label: 3, value: 'text-[#FEA32B]' },
  { label: 4, value: 'text-[#FEA32B]' },
  { label: 5, value: 'text-[#FEA32B]' },
];

const HomeTopicView = () => {
  // 话题列表
  const [topicList, setTopicList] = useState<ListType>();
  // 获取话题列表
  const getListGambit = async () => {
    const res = await HomeAPI.getAppGambitList({
      pageNo: 1,
      pageSize: 10,
    });
    if (res && res.code === '200') {
      setTopicList(res.result.list || []);
    }
  };
  // 组件挂载
  useEffect(() => {
    getListGambit().then();
  }, []);
  return (
    <Affix offsetTop={58}>
      <HomeTopicWrap>
        <div className="title">热门话题</div>
        {topicList?.map((i, j) => (
          <div key={j} className="mb-3 flex">
            <div className={`${indexList[j]?.value} font-bold`}>{j + 1}</div>
            <div className="ml-2 cursor-pointer text-ellipsis hover:text-tag">
              {i.gambitName}
            </div>
          </div>
        ))}
      </HomeTopicWrap>
    </Affix>
  );
};

export default HomeTopicView;
// 样式
const HomeTopicWrap = styled.div`
  position: relative;
  width: 20rem;
  min-height: 20rem;
  //background: linear-gradient(
  //  180deg,
  //  #fff9f8 2%,
  //  #fff9f8 2%,
  //  #fffdfc 15%,
  //  #ffffff 24%,
  //  #ffffff 100%
  //);
  border-radius: 0.42rem;
  box-sizing: border-box;
  background-image: url('https://file.iuav.com/file/sharefly-topic-bg.png');
  background-size: cover;
  border: 1px solid #e3e3e3;
  padding: 0.75rem 1.25rem 0 1.25rem;
  .title {
    font-size: 16px;
    font-weight: bold;
    color: #333;
    margin-bottom: 1rem;
  }
`;
