import { InterFunction, InterListFunction } from '@/api/interface';

// 一级行业列表
export type GetIndustryListPagesType = InterListFunction<
  {
    pageNo: number;
    pageSize: number;
    typeName?: string;
    id?: number;
  },
  {
    createTime: string;
    description: string;
    id: number;
    inspectionDTOS: Array<{
      caseImg: string;
      caseVideo: string;
      companyInspectionDTOS: Array<{
        companyInfoId: number;
        companyName: string;
        detailPage: string;
        id: number;
        industryTypeDTO: {};
        inspectionDTO: {};
        inspectionFileDTOS: Array<{
          companyInspectionId: number;
          fileType: number;
          fileUrl: string;
          first: number;
          id: number;
        }>;
        inspectionFirstImg: string;
        inspectionId: number;
        inspectionPriceUnitId: number;
        inspectionTagDTO: {
          id: number;
          inspectionId: number;
          tagName: string;
        };
        inspectionTagId: number;
        price: number;
        priceRemark: string;
        remark: string;
        saleState: number;
        serviceArea: string;
      }>;
      id: number;
      industryTypeId: number;
      inspectionDescription: string;
      inspectionImg: string;
      inspectionName: string;
      inspectionNo: string;
      saleState: number;
    }>;
    saleState: number;
    typeImg: string;
    typeName: string;
  }
>;
// 单位服务列表-小程序展示
export type GetListAPPCompanyInspectionPageType = InterListFunction<
  {
    companyInfoId?: number;
    industryTypeId?: number;
    inspectionId?: number;
    inspectionTagId?: number;
    keyword?: string;
  },
  {
    id: number;
    companyInfoId: number;
    serviceArea: string;
    inspectionId: number;
    inspectionTagId: null;
    price: number;
    priceRemark: string;
    inspectionPriceUnitId: number;
    detailPage: string;
    saleState: number;
    remark: string;
    inspectionFirstImg: string;
    industryTypeDTO: {
      id: number;
      typeName: string;
      typeImg: null;
      description: null;
      saleState: null;
      createTime: null;
      inspectionDTOS: null;
    };
    inspectionDTO: {
      id: number;
      inspectionNo: string;
      inspectionName: string;
      industryTypeId: null;
      inspectionImg: null;
      inspectionDescription: null;
      saleState: null;
      caseImg: null;
      caseVideo: null;
      createTime: null;
      companyInspectionDTOS: null;
    };
    inspectionTagDTO: {
      id: null;
      tagName: null;
      inspectionId: number;
    };
    inspectionFileDTOS: Array<{
      id: number;
      fileType: number;
      first: number;
      companyInspectionId: number;
      fileUrl: string;
    }>;
    companyName: string;
  }
>;
// 价格单位列表
export type ListInspectionPriceUnit = InterFunction<
  {},
  {
    id: number;
    unitName: string;
  }[]
>;
// 单位服务详情
export type GetCompanyInspectionById = InterFunction<
  {
    id: number;
  },
  {
    companyInfoId: number;
    companyName: string;
    detailPage: string;
    id: number;
    industryTypeDTO: {
      createTime: string;
      description: string;
      id: number;
      inspectionDTOS: Array<{
        caseImg: string;
        caseVideo: string;
        companyInspectionDTOS: null;
        id: number;
        industryTypeId: number;
        inspectionDescription: string;
        inspectionImg: string;
        inspectionName: string;
        inspectionNo: string;
        saleState: number;
      }>;
      saleState: number;
      typeImg: string;
      typeName: string;
    };
    inspectionDTO: {
      caseImg: string;
      caseVideo: string;
      companyInspectionDTOS: null;
      id: number;
      industryTypeId: number;
      inspectionDescription: string;
      inspectionImg: string;
      inspectionName: string;
      inspectionNo: string;
      saleState: number;
    };
    inspectionFileDTOS: Array<{
      companyInspectionId: number;
      fileType: number;
      fileUrl: string;
      first: number;
      id: number;
    }>;
    inspectionFirstImg: string;
    inspectionId: number;
    inspectionPriceUnitId: number;
    inspectionTagDTO: {
      id: number;
      inspectionId: number;
      tagName: string;
    };
    inspectionTagId: number;
    price: number;
    priceRemark: string;
    remark: string;
    saleState: number;
    serviceArea: string;
  }
>;
// 单位查询
export type GetCompanyInfoById = InterFunction<
  {
    id: number;
  },
  {
    address: string;
    brandLogo: string;
    brandName: string;
    companyName: string;
    companyType: number;
    companyUserName: string;
    content: string;
    creditCode: string;
    fullName: string;
    id: number;
    lat: number;
    leader: number;
    licenseImg: string;
    lon: number;
    phoneNum: number;
    remark: string;
    score: string;
    userAccountId: number;
    backImg: string;
    backUserAccountId: number;
    backUserId: number;
  }
>;
