import { InterDataType, InterFunction } from '@/api/interface';

// 小程序分类信息--含一二级分类
export type GetAppCategoryInfo = InterFunction<
  {},
  {
    id: number;
    name: string;
    description?: string;
    icon?: string;
    createTime?: string;
    updateTime?: null;
    subDTOList?: Array<{
      id: number;
      name: string;
      description?: string;
      categoryPrimaryId?: number;
      createTime?: string;
      updateTime?: string;
      subDTOList?: InterDataType<QueryGoodsInfoByCategorySub>;
    }>;
    sort?: number;
  }[]
>;
export type QueryGoodsInfoByCategorySub = InterFunction<
  number[],
  {
    categoryPrimaryId: number;
    categorySubId: number;
    createTime: string;
    description: string;
    goodsDetails: string;
    goodsLabel: string;
    goodsSpecList: Array<{
      chooseType: number;
      goodsSpecValuesList: Array<{
        channelPrice: number;
        goodsSpecId: number;
        id: number;
        partNo: string;
        salePrice: number;
        showPrice: number;
        specValueImage: string;
        specValueName: string;
        stock: number;
      }>;
      id: number;
      mallGoodsId: number;
      must: number;
      skuUnitId: number;
      specName: string;
    }>;
    id: number;
    labelShow: number;
    resourcesList: Array<{
      id: number;
      type: number;
      url: string;
    }>;
    shelfStatus: number;
    tradeName: string;
    userAccountId: number;
    recommend: number;
    priceShow: number;
    specAttrList: null;
    priceStock: Array<{
      id: number;
      productSpec: string;
      salePrice: number;
      skuImage: null;
      channelPrice: null;
      stock: null;
      skuNo: null;
    }>;
    companyName: string;
  }[]
>;
// 小程序商品详情
export type AppMallGoodsDetails = InterFunction<
  { id: number },
  {
    categoryPrimaryId: number;
    categorySubId: number;
    createTime: string;
    description: string;
    goodsDetails: string;
    goodsLabel: string;
    id: number;
    labelShow: number;
    priceStock: Array<{
      channelPrice: number;
      id: number;
      productSpec: string;
      salePrice: number;
      skuImage: string;
      skuNo: string;
      stock: number;
    }>;
    resourcesList: Array<{
      id: number;
      type: number;
      url: string;
    }>;
    shelfStatus: number;
    specAttrList: Array<{
      id: number;
      specName: string;
      specValuesList: Array<{
        id: number;
        specName: string;
        specValuesList: null;
      }>;
    }>;
    tradeName: string;
    userAccountId: number;
    priceShow: number;
  }
>;
// pc-后台用户id单位查询
export type GetCompanyInfoByBUId = InterFunction<
  {
    backUserAccountId: number;
  },
  {
    address: string;
    brandLogo: string;
    brandName: string;
    companyName: string;
    companyType: number;
    companyUserName: string;
    content: string;
    creditCode: string;
    fullName: string;
    id: number;
    lat: number;
    leader: number;
    licenseImg: string;
    lon: number;
    phoneNum: string;
    remark: string;
    score: string;
    userAccountId: number;
    province: string;
    city: string;
  }
>;
// 租赁商品详情
export type LeaseGoodsDetailsType = InterFunction<
  {
    id: number;
  },
  {
    id: number;
    tradeName: string;
    sellingPoint: string;
    level: number;
    shelfStatus: number;
    productTypeId: number;
    brandInfoId: number;
    deviceModeId: number;
    productParam: string;
    resourcesList: Array<{
      id: number;
      url: string;
      type: number;
    }>;
    specAttrList: Array<{
      id: number;
      specName: string;
      specValuesList: Array<{
        id: number;
        specName: string;
      }>;
    }>;
    priceStock: Array<{
      id: number;
      productSpec: string;
      cashPledge: number;
      threeDaysRental: number;
      sevenDaysRental: null;
      thirtyDaysRental: null;
      ninetyDaysRental: null;
      maxDaysRental: null;
      skuImage: string;
      stock: null;
      stockOut: number;
    }>;
    productDetails: string;
    minLeaseTerm: number;
    maxLeaseTerm: number;
    leasePartsList: Array<{
      id: number;
      name: string;
      number: number;
      price: number;
    }>;
    shipAddress: number;
    returnAddress: number;
    logisticsCompany: string;
    modeOfDelivery: number;
    showPrice: number;
    createTime: string;
    userAccountId: number;
    cashPledgeRange: null;
    rentalRange: null;
    stock: null;
    districtCode: null;
    productTypeName: string;
    brandName: string;
    deviceModeName: string;
    modeOfDeliveryInfo: string;
  }
>;
