import {
  InterDataType,
  InterFunction,
  InterItemFunction,
  InterListFunction,
} from '@/api/interface';
import { QueryGoodsInfoByCategorySub } from '@/api/interface/mall';

// 获取图片-小程序
export type ListBannerImgType = InterFunction<
  { moduleCode: string },
  {
    bannerImg: string;
    bannerName: string;
    bannerPoster: null;
    bannerType: number;
    bannerUrl: string;
    createTime: string;
    deleted: number;
    detailInfo: null;
    endTime: null;
    goodsId: null;
    id: number;
    moduleId: number;
    sort: number;
    startTime: null;
    textContent: string;
    using: number;
  }[]
>;
// 小程序分类信息--含一二级分类
export type AppCategoryInfoType = InterFunction<
  {
    type: number;
  },
  {
    id: number;
    name: string;
    description?: string;
    icon?: string;
    createTime?: string;
    updateTime?: null;
    subDTOList: Array<{
      id: number;
      name: string;
      description?: string;
      categoryPrimaryId?: number;
      createTime?: string;
      updateTime?: string;
      subDTOList?: InterDataType<QueryGoodsInfoByCategorySub>;
    }>;
    sort?: number;
  }[]
>;
// 一级行业列表
export type IndustryListPagesType = InterListFunction<
  {
    pageNo: number;
    pageSize: number;
    typeName?: string;
    id?: number;
  },
  {
    createTime: string;
    description: string;
    id: number;
    inspectionDTOS: Array<{
      caseImg: string;
      caseVideo: string;
      companyInspectionDTOS: Array<{
        companyInfoId: number;
        companyName: string;
        detailPage: string;
        id: number;
        industryTypeDTO: {};
        inspectionDTO: {};
        inspectionFileDTOS: Array<{
          companyInspectionId: number;
          fileType: number;
          fileUrl: string;
          first: number;
          id: number;
        }>;
        inspectionFirstImg: string;
        inspectionId: number;
        inspectionPriceUnitId: number;
        inspectionTagDTO: {
          id: number;
          inspectionId: number;
          tagName: string;
        };
        inspectionTagId: number;
        price: number;
        priceRemark: string;
        remark: string;
        saleState: number;
        serviceArea: string;
      }>;
      id: number;
      industryTypeId: number;
      inspectionDescription: string;
      inspectionImg: string;
      inspectionName: string;
      inspectionNo: string;
      saleState: number;
    }>;
    saleState: number;
    typeImg: string;
    typeName: string;
  }
>;
// 小程序——列表————飞手执照及能力认证
export type AppListPilotType = InterListFunction<
  {
    abilityId?: number;
    accountNumber?: string;
    areaNumber?: number;
    auditStatus?: number;
    id?: number;
    licenseType?: string;
  },
  {
    abilityUrl: string;
    age: number;
    areaNumber: number;
    auditStatus: string;
    createTime: string;
    id: number;
    individualResume: string;
    licenseNumber: number;
    licenseType: string;
    licenseUrl: string;
    phoneNum: number;
    pilotAbility: Array<{
      abilityId: number;
      abilityName: string;
      id: number;
    }>;
    remark: string;
    residentCity: string;
    sex: number;
    timeOfApplication: string;
    updateTime: string;
    userAccountId: number;
    userName: string;
    yearsOfWorking: number;
    userImg: string;
    status: boolean;
  }
>;
// 话题列表
export type GetAppGambitListType = InterListFunction<
  {
    gambitId?: number;
    /**
     * 话题名称
     */
    gambitName?: string;
    /**
     * 话题属性 1普通 2热门 3推荐
     */
    gambitProperty?: number;
  },
  {
    /**
     * 话题参与讨论数量
     */
    discussionCount?: number;
    /**
     * 话题封面
     */
    gambitCover?: string;
    /**
     * 话题图标
     */
    gambitIcon?: string;
    /**
     * 话题名称
     */
    gambitName: string;
    /**
     * 话题属性
     */
    gambitProperty: number;
    id: number;
    /**
     * 贴子数
     */
    postCount?: number;
  }
>;
// 小程序-列表——需求发布
export type AppPublishListType = InterFunction<
  {
    cityCode?: string; // 市编码
    districtCode?: string; // 区编码
    isHighCommission?: boolean; // 是否按高薪排序 可不传
    isNewRequirements?: boolean; // 是否按时间排序 可不传
    provinceCode?: string; // 省编
  },
  {
    createTime: string;
    cityCode: number;
    districtCode: number;
    doing: string;
    flyerPort: string;
    insurance: string;
    latitude: number;
    longitude: number;
    orderLevelEnum: string;
    orderNumber: string;
    orderStatus: string;
    paramMoney: number;
    preemptTotalAmount: number;
    provinceCode: number;
    publish: number;
    publishAccountId: number;
    publisherNumber: string;
    publishName: string;
    publishPhone: string;
    requireDescription: string;
    requirementTypeId: number;
    requireUrl: string;
    serviceId: number;
    serviceName: string;
    solved: boolean;
    taskAddress: string;
    taskEndTime: string;
    taskStartTime: string;
    taskTitle: string;
    totalAmount: number;
    userPort: string;
    waiting: string;
    orderAmount: number;
    orderLevel: null;
    reason: null;
    requirementTypeName: null;
    requirementsInfoId: null;
    updateOrderAmount: null;
    url: null;
    userAccountId: number;
    id: number;
    requireNum: number;
  }[]
>;
// 需求类型列表
export type RequirementsListType = InterFunction<
  any,
  {
    id: number;
    typeName: string;
    typeSubclassList: Array<{
      id: number;
      requirementsTypeId: number;
      name: string;
    }>;
  }[]
>;
// 合作商家列表-根据合作标签id获取
export type ListCompanyInfoByCoopIdType = InterListFunction<
  {
    coopId: number;
    lat: number;
    lon: number;
    pageNo: number;
    pageSize: number;
  },
  {
    address: string;
    brandLogo: string;
    brandName: string;
    companyName: string;
    companyType: number;
    companyUserName: string;
    content: string;
    creditCode: string;
    fullName: string;
    id: number;
    lat: number;
    leader: number;
    licenseImg: string;
    lon: number;
    phoneNum: number;
    remark: string;
    score: string;
    userAccountId: number;
    backImg: string;
    city: string;
    distance: number;
    district: string;
    province: string;
    backUserAccountId: number;
  }
>;
// 商品-推荐商品
type MallGoodsType = {
  /**
   * 一级分类id
   */
  categoryPrimaryId: number;
  /**
   * 二级分类id
   */
  categorySubId: number;
  /**
   * 创建时间 用作列表回显
   */
  createTime?: Date;
  /**
   * 商品描述
   */
  description: string;
  /**
   * 商品详情 富文本
   */
  goodsDetails?: string;
  /**
   * 商品标签
   */
  goodsLabel?: string;
  /**
   * 商品热度
   */
  hot?: number;
  /**
   * id
   */
  id: number;
  /**
   * 标签是否显示 0否 1是
   */
  labelShow?: number;
  /**
   * 价格是否显示 0不显示 1显示
   */
  priceShow?: number;
  /**
   * 价格库存排列组合表信息
   */
  priceStock?: {
    /**
     * 渠道价格
     */
    channelPrice?: number;
    /**
     * id
     */
    id?: number;
    /**
     * 商品规格
     */
    productSpec?: string;
    /**
     * 销售价格
     */
    salePrice?: number;
    /**
     * sku图片
     */
    skuImage?: string;
    /**
     * sku编号
     */
    skuNo?: string;
    /**
     * 库存
     */
    stock?: number;
  }[];
  /**
   * 是否推荐 0否 1是
   */
  recommend?: number;
  /**
   * 商品资源:图片or视频及其他
   */
  resourcesList: {
    /**
     * id
     */
    id: number;
    /**
     * 类型：0主图 1副图 2视频
     */
    type: number;
    /**
     * url
     */
    url: string;
  }[];
  /**
   * 商品状态
   */
  shelfStatus: number;
  /**
   * 规格
   */
  specAttrList?: {
    /**
     * id
     */
    id?: number;
    /**
     * 规格名称
     */
    specName: string;
    /**
     * 规格值信息
     */
    specValuesList: {
      /**
       * id
       */
      id?: number;
      /**
       * 规格名称
       */
      specName: string;
    }[];
  }[];
  /**
   * 商品名称
   */
  tradeName: string;
  companyName: string;
  /**
   * 店铺id 小程序用
   */
  userAccountId?: number;
};
// 商品-推荐商品
export type RecommendGoodsType = InterFunction<
  any,
  {
    categoryPrimaryDTO: {
      /**
       * 创建时间
       */
      createTime?: string;
      /**
       * 描述
       */
      description?: string;
      /**
       * icon图标
       */
      icon?: string;
      /**
       * id
       */
      id: number;
      /**
       * 分类名称
       */
      name: string;
      /**
       * 顺序
       */
      sort?: number;
      /**
       * 二级分类
       */
      subDTOList?: {
        /**
         * 一级id不能为空
         */
        categoryPrimaryId: number;
        /**
         * 创建时间
         */
        createTime: string;
        /**
         * 描述
         */
        description?: string;
        /**
         * id
         */
        id: number;
        /**
         * 分类名称
         */
        name: string;
        /**
         * 更新时间
         */
        updateTime?: string;
      }[];
      /**
       * 更新时间
       */
      updateTime?: null;
    };
    mallGoodsList: MallGoodsType[];
  }[]
>;
// 项目资讯-新闻列表
export type ListNewsType = InterListFunction<
  {
    cityCode?: number;
    date?: string;
    districtCode?: number;
    provinceCode?: number;
    keyword?: string;
    isHot?: number;
  },
  {
    createTime?: string;
    id?: number;
    newsAuthor?: string;
    newsContents?: string;
    newsTitle?: string;
    origin?: string;
    surfaceImg?: string;
    updateTime?: string;
    userAccountId?: number;
    isHot?: number;
  }
>;
// 项目资讯-招投标
export type ListTenderInfoType = InterListFunction<
  {
    cityCode?: number;
    date?: string;
    districtCode?: number;
    provinceCode?: number;
    keyword?: string;
  },
  {
    apply?: number;
    createTime?: string;
    id?: number;
    tenderContent?: string;
    tenderInfoNo?: string;
    tenderNewsId?: number;
    tenderPrice?: number;
    tenderTitle?: string;
  }
>;
// 租赁-品牌-列表
export type ListBrandInfoType = InterItemFunction<
  {},
  {
    brandName: string;
    createTime: string;
    id: number;
    modeInfoList: {
      brandInfoId: number;
      id: number;
      modeName: string;
      productTypeId: number;
      tag: string;
    }[];
  }[]
>;
// web-首页分类数据-展示
export type GetPageHomeCategoriesType = InterFunction<
  { type: number },
  {
    id: number;
    categoryName: string;
  }[]
>;
// 论坛列表
export type ForumListType = InterItemFunction<
  {
    userId?: number;
    gambitId?: number;
    userAccountId?: number;
    gambitName?: string;
  },
  {
    id: number;
    commentCount: number;
    description: string;
    likes: boolean;
    likesCount: number;
    transpond: number;
    title: string;
    mediaVO: { type: number; url: string }[];
    userAccountId: number;
    userBaseInfo: {
      nickName: string;
      userImg: string;
    };
    forumGambitDTOList?: {
      /**
       * 话题参与讨论数量
       */
      discussionCount?: number;
      /**
       * 话题封面
       */
      gambitCover?: string;
      /**
       * 话题图标
       */
      gambitIcon?: string;
      /**
       * 话题名称
       */
      gambitName?: string;
      /**
       * 话题属性
       */
      gambitProperty?: number;
      id: number;
      /**
       * 贴子数
       */
      postCount?: number;
    }[];
    status: number;
    gambitName?: string[];
    dynamicPublishTime: string;
    commentAndReplyVO: {
      commentAndReplyVO: null;
      commentCount: null;
      description: string;
      dynamicPublishTime: string;
      id: number;
      lat: null;
      likes: null;
      likesCount: null;
      location: null;
      lon: null;
      mediaVO: null;
      userAccountId: number;
      userBaseInfo: {
        nickName: string;
        userImg: string;
      };
    }[];
    forumReviewVO?: {
      /**
       * 评论内容
       */
      content?: string;
      /**
       * 创建时间
       */
      createTime?: string;
      /**
       * 动态id
       */
      dynamicId?: number;
      /**
       * id
       */
      id: number;
      /**
       * 评论点赞数
       */
      likeCount?: number;
      /**
       * pid
       */
      pid?: number;
      /**
       * 回复id
       */
      reviewId?: number;
      /**
       * 更新时间
       */
      updateTime?: string;
      /**
       * 用户id
       */
      userAccountId?: number;
      status?: number;
      userAccountVO: {
        nickName: string;
        userImg: string;
        id: number;
      };
    };
  }[]
>;
// 租赁商品列表
export type LeaseGoodsListType = InterListFunction<
  {
    modelInfoId?: number;
    brandInfoId?: number;
    districtCode?: string;
    productTypeId?: number;
    shelfStatus?: number;
    tradeName?: string;
    userAccountId?: number;
  },
  {
    id: number;
    tradeName: string;
    sellingPoint: string;
    level: null;
    shelfStatus: number;
    productTypeId: number;
    brandInfoId: null;
    deviceModeId: null;
    productParam: string;
    resourcesList: Array<{
      id: number;
      url: string;
      type: number;
    }>;
    specAttrList: null;
    priceStock: Array<{
      id: null;
      productSpec: null;
      cashPledge: number;
      threeDaysRental: number;
      sevenDaysRental: number;
      thirtyDaysRental: null;
      ninetyDaysRental: null;
      maxDaysRental: null;
      skuImage: null;
      stock: number;
      stockOut: null;
    }>;
    productDetails: null;
    minLeaseTerm: number;
    maxLeaseTerm: null;
    leasePartsList: null;
    shipAddress: null;
    returnAddress: null;
    logisticsCompany: null;
    modeOfDelivery: null;
    showPrice: number;
    createTime: string;
    userAccountId: number;
    cashPledgeRange: string;
    rentalRange: string;
    stock: number;
    districtCode: null;
    productTypeName: null;
    brandName: null;
    deviceModeName: null;
    modeOfDeliveryInfo: null;
    companyName: string;
  }
>;
