import request, { Response } from '~/api/request';

import config from './config';

export interface RegionResp {
  childInfo?: RegionResp[] | null;
  id: number;
  level: number;
  name: string;
  pid: number;
}
export interface UserInfoResp {
  id: number;
  accountType: number;
  uid: string;
  phoneNum: string;
  userName: string;
  nickName: string;
  userImg: string;
  userSex: number;
  email: string;
  source: number;
  accountStatus: number;
  remark: string;
  portType: number;
  createTime: string;
  companyAuthStatus: number;
  token: string;
  cooperationTagId: number | null;
  cooperationTagVOS: {
    createTime: string;
    id: number;
    tagDescription: string;
    tagImg: string;
    tagName: string;
    tagRequire: string;
  }[];
}

export interface TestAppletLoginResp {
  userAccountId: number;
  token: string;
  uid: string;
  phoneNum?: string;
  nickName: string;
  sessionKey?: any;
}

export default {
  // 获取区域数据
  region: (): Promise<Response<Array<RegionResp>>> => {
    return request('/pms/webDevice/getSecondDistrictInfo');
  },
  // 测试-小程序unionId登录-注册
  testAppletLogin: (): Promise<Response<TestAppletLoginResp>> => {
    const params = new URLSearchParams();
    params.append('unionId', 'oQZEd5hy0Qrwaj10BGtP8xq8vH--s88888');
    return request(
      '/userapp/auth/testAppletLogin',
      'post',
      {},
      {
        headers: {
          'Content-Type': 'application/x-www-form-urlencoded',
        },
        body: params,
      },
    );
  },
  // 生成小程序码
  getAppletQRCode: (params: { randomLoginCode: string }) => {
    return request('/userapp/wx/getAppletQRCode', 'get', {
      page: 'page-identity/identity-empower/index',
      scene: `randomLoginCode=${params.randomLoginCode}`,
    });
  },
  // 查询登录信息
  getLoginInfo: (params: { randomLoginCode: string }) => {
    return request('/userapp/temp-auth/getLoginInfo', 'get', params, {
      hideError: true, // 隐藏错误提示
    });
  },
  // 获取用户基本信息
  userInfo: (): Promise<Response<UserInfoResp>> => {
    return request('/userapp/user-account/info', 'get');
  },
  // 图片上传地址
  imgOss: () => {
    return `${config.baseUrl}/pms/upload/imgOss`;
  },
  // 文件上传地址
  fileUpload: () => {
    return `${config.baseUrl}/pms/upload/breakpoint`;
  },
  // 宣传中心
  listBannerImg: (
    moduleCode: string,
  ): Promise<
    Response<
      {
        id: number;
        bannerImg: string;
      }[]
    >
  > => {
    return request('/release/module/listBannerImg', 'get', {
      moduleCode,
    });
  },
};
