import React, { useEffect, useState } from 'react';

import { Carousel } from 'antd';
import Image from 'next/image';

import commonApi from '~/api';

import { Box } from './styled';

export default function RotationChart() {
  const [bannerList, setBannerList] = useState<string[]>([]);
  const getPropagandaCenter = () => {
    commonApi.listBannerImg('OFFICIAL_BANNER').then((res) => {
      setBannerList((res.result || []).map((item) => item.bannerImg));
    });
  };
  useEffect(() => {
    getPropagandaCenter();
  }, []);
  return (
    <Box>
      <Carousel className='rotationChart' autoplay dots={{ className: 'botsBotton' }}>
        {bannerList.map((item) => (
          <div key={item}>
            <h3 className='contentStyle'>
              <Image src={item} alt='error' fill />
            </h3>
          </div>
        ))}
      </Carousel>
    </Box>
  );
}
