import React, { useEffect, useState } from 'react';
import { Tabs, Button, Cascader, Space, DatePicker, DatePickerProps } from 'antd';
import styles from './index.module.scss';
import Layout from '~/components/layout';

interface Option {
  value: string | number;
  label: string;
  children?: Option[];
}

const options: Option[] = [
  {
    value: 'zhejiang',
    label: 'Zhejiang',
    children: [
      {
        value: 'hangzhou',
        label: 'Hangzhou',
        children: [
          {
            value: 'xihu',
            label: 'West Lake',
          },
        ],
      },
    ],
  },
  {
    value: 'jiangsu',
    label: 'Jiangsu',
    children: [
      {
        value: 'nanjing',
        label: 'Nanjing',
        children: [
          {
            value: 'zhonghuamen',
            label: 'Zhong Hua Men',
          },
        ],
      },
    ],
  },
];

const onChange = (value: string[]) => {
  console.log(value);
};

const onDateChange: DatePickerProps['onChange'] = (date, dateString) => {
  console.log(date, dateString);
};

const operations = (
  <Space size={8}>
    <Cascader options={options} onChange={onChange} placeholder='Please select' />
    <DatePicker onChange={onDateChange} />
  </Space>
);

//项目需求
const requirements = function () {
  return (
    <Layout>
      <div className={styles.requirements}>
        <div className={styles.item}>
          <div className={styles.logo}></div>
          <div className={styles.info}>
            <div className={styles.title}>项目需求：电力巡检需要5名飞手</div>
            <div className={styles.desc}>
              具体需求：电力巡检需要5名飞手，山东临沂
            </div>
          </div>
        </div>
        <div className={`${styles.item} ${styles.noResolve}`}>
          <div className={styles.logo}></div>
          <div className={styles.info}>
            <div className={styles.title}>项目需求：电力巡检需要5名飞手</div>
            <div className={styles.desc}>
              具体需求：电力巡检需要5名飞手，山东临沂
            </div>
          </div>
        </div>
      </div>
    </Layout>
  ); 
};

const items = ['项目需求', '招投标项目', '业务案例', '行业新闻'].map((value) => {
  let children: JSX.Element | string = <></>;

  switch(value){
    case '项目需求':
      children = requirements();
      break;

    default:
      children = `Content of tab ${value}`;
        
  }
  return {
    label: `${value}`,
    key: value,
    children: children,
  };
});

export default function Mall() {
  return (
    <div style={{ paddingTop: 180, backgroundColor: '#fff', minHeight: 820 }}>
      <div className='page'>
        <div className={styles.banner}></div>
        <Tabs
          className={styles.tabs}
          tabBarExtraContent={operations}
          items={items}
          tabBarGutter={41}
        />
      </div>
    </div>
  );
}
