import styles from './index.module.scss';

const qrcodeList = [
  {
    img: '',
    title: '科比特官网',
  },
  {
    img: '',
    title: '云享飞服务号',
  },
  {
    img: '',
    title: '云享飞小程序',
  },
  {
    img: '',
    title: '官方社群',
  },
];

export default function Footer() {
  return (
    <div className={styles.footer}>
      <div className={styles.logo}></div>
      <div className={styles.qrcodeList}>
        {
          qrcodeList.map((item, i) => {
            return (
              <div className={styles.qrcodeItem} key={i}>
                <img className={styles.qrcodeImg} src={item.img}></img>
                <div className={styles.qrcodeTitle}>{item.title}</div>
              </div>
            );
          })
        }
        
      </div>
      <div className={styles.rightText}>
        <div className={styles.number}>100W</div>
        <div className={styles.text}>无人机新媒体矩阵等你来关注</div>
      </div>
    </div>
  );
}
